/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.util.Arrays;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiPacketContext;
import org.apache.hertzbeat.collector.collect.ipmi2.client.IpmiSession;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.common.IpmiCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.AbstractSessionIpmiPayload;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.IpmiPayloadType;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.payload.MessageStatusCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.IpmiAuthenticationCode;
import org.apache.hertzbeat.collector.collect.ipmi2.protocol.ipmi.security.authentication.IpmiAuthentication;
import org.apache.hertzbeat.collector.collect.ipmi2.utils.ByteOrderUtils;

public class RakpMessage2
extends AbstractSessionIpmiPayload {
    public MessageStatusCode messageStatusCode;
    public int consoleSessionId;
    public byte[] systemRandom;
    public byte[] systemGuid;
    public byte[] keyExchangeAuthenticationCode;

    @Override
    public int getWireLength(IpmiPacketContext context) {
        return 40 + this.keyExchangeAuthenticationCode.length;
    }

    @Override
    public void toWire(IpmiPacketContext context, ByteBuffer buffer) {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public void fromWire(IpmiPacketContext context, ByteBuffer buffer) {
        this.messageTag = buffer.get();
        this.messageStatusCode = IpmiCode.fromBuffer(MessageStatusCode.class, buffer);
        RakpMessage2.ignoreBytes(buffer, 2);
        this.consoleSessionId = ByteOrderUtils.readLeInt(buffer);
        this.systemRandom = ByteOrderUtils.readBytes(buffer, 16);
        this.systemGuid = ByteOrderUtils.readBytes(buffer, 16);
        this.keyExchangeAuthenticationCode = ByteOrderUtils.readBytes(buffer, buffer.remaining());
        byte[] hash = this.verifyKeyExchangeAuthenticationCode(context.getIpmiSession());
        if (!Arrays.equals(hash, this.keyExchangeAuthenticationCode)) {
            throw new RuntimeException("Key exchange authentication code mismatch");
        }
    }

    @Override
    public IpmiPayloadType getPayloadType() {
        return IpmiPayloadType.RAKPMessage2;
    }

    public byte[] verifyKeyExchangeAuthenticationCode(IpmiSession session) {
        String userName = session.getUserName();
        int length = 58 + (userName == null ? 0 : userName.length());
        ByteBuffer buffer = ByteBuffer.allocate(length);
        ByteOrderUtils.writeLeInt(buffer, session.getConsoleSessionId());
        ByteOrderUtils.writeLeInt(buffer, session.getSystemSessionId());
        ByteOrderUtils.writeBytes(buffer, session.getConsoleRandomNumber());
        ByteOrderUtils.writeBytes(buffer, this.systemRandom);
        ByteOrderUtils.writeBytes(buffer, this.systemGuid);
        byte t = RakpMessage2.setBits((byte)0, 4, 1, 1);
        AbstractSessionIpmiPayload.MaximumPrivilegeLevel maximumPrivilegeLevel = session.getMaximumPrivilegeLevel();
        t = RakpMessage2.setBits(t, 0, 15, maximumPrivilegeLevel.getCode());
        buffer.put(t);
        if (userName != null) {
            byte[] usernameBytes = userName.getBytes(StandardCharsets.US_ASCII);
            buffer.put((byte)usernameBytes.length);
            buffer.put(usernameBytes);
        } else {
            buffer.put((byte)0);
        }
        IpmiAuthenticationCode authenticationCode = session.getAuthenticationAlgorithm();
        IpmiAuthentication authentication = authenticationCode.newIpmiAuthentication();
        if (authentication == null) {
            throw new UnsupportedOperationException("Unsupported authentication code: " + authenticationCode);
        }
        try {
            authentication.setKey(session.getPassword().getBytes(StandardCharsets.US_ASCII));
            authentication.setData(buffer.array());
            return authentication.getHash();
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
    }
}

