/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.entity.manager;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import org.apache.hertzbeat.common.util.JsonUtil;
import org.springframework.data.annotation.CreatedDate;
import org.springframework.data.annotation.LastModifiedDate;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@Table(name="hzb_param", indexes={@Index(name="idx_hzb_param_monitor_id", columnList="monitor_id")}, uniqueConstraints={@UniqueConstraint(name="uk_hzb_param_monitor_field", columnNames={"monitor_id", "field"})})
@Schema(description="Parameter Entity")
@EntityListeners(value={AuditingEntityListener.class})
public class Param {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Schema(title="Parameter primary key index ID", example="87584674384", accessMode=Schema.AccessMode.READ_ONLY)
    private Long id;
    @Schema(title="Monitor task ID", example="875846754543", accessMode=Schema.AccessMode.READ_WRITE)
    @Column(name="monitor_id")
    private Long monitorId;
    @Schema(title="Parameter identifier field", example="port", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=100)
    @Column(name="field")
    @NotBlank(message="field can not null")
    private @Size(max=100) @NotBlank(message="field can not null") String field;
    @Schema(title="parameter values", example="8080", accessMode=Schema.AccessMode.READ_WRITE)
    @Size(max=8126)
    @Column(length=8126)
    private @Size(max=8126) String paramValue;
    @Schema(title="Parameter types 0: number 1: string 2: encrypted string 3:map mapped json string 4:arrays string", accessMode=Schema.AccessMode.READ_WRITE)
    @Min(value=0L)
    private @Min(value=0L) byte type;
    @Schema(title="Record create time", example="1612198922000", accessMode=Schema.AccessMode.READ_ONLY)
    @CreatedDate
    private LocalDateTime gmtCreate;
    @Schema(title="Record modify time", example="1612198444000", accessMode=Schema.AccessMode.READ_ONLY)
    @LastModifiedDate
    private LocalDateTime gmtUpdate;

    public Param clone() {
        return (Param)JsonUtil.fromJson(JsonUtil.toJson(this), this.getClass());
    }

    public static ParamBuilder builder() {
        return new ParamBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getMonitorId() {
        return this.monitorId;
    }

    public String getField() {
        return this.field;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public byte getType() {
        return this.type;
    }

    public LocalDateTime getGmtCreate() {
        return this.gmtCreate;
    }

    public LocalDateTime getGmtUpdate() {
        return this.gmtUpdate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setMonitorId(Long monitorId) {
        this.monitorId = monitorId;
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public void setGmtCreate(LocalDateTime gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtUpdate(LocalDateTime gmtUpdate) {
        this.gmtUpdate = gmtUpdate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Param)) {
            return false;
        }
        Param other = (Param)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getType() != other.getType()) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$monitorId = this.getMonitorId();
        Long other$monitorId = other.getMonitorId();
        if (this$monitorId == null ? other$monitorId != null : !((Object)this$monitorId).equals(other$monitorId)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        String this$paramValue = this.getParamValue();
        String other$paramValue = other.getParamValue();
        if (this$paramValue == null ? other$paramValue != null : !this$paramValue.equals(other$paramValue)) {
            return false;
        }
        LocalDateTime this$gmtCreate = this.getGmtCreate();
        LocalDateTime other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        LocalDateTime this$gmtUpdate = this.getGmtUpdate();
        LocalDateTime other$gmtUpdate = other.getGmtUpdate();
        return !(this$gmtUpdate == null ? other$gmtUpdate != null : !((Object)this$gmtUpdate).equals(other$gmtUpdate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Param;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getType();
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $monitorId = this.getMonitorId();
        result = result * 59 + ($monitorId == null ? 43 : ((Object)$monitorId).hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        String $paramValue = this.getParamValue();
        result = result * 59 + ($paramValue == null ? 43 : $paramValue.hashCode());
        LocalDateTime $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        LocalDateTime $gmtUpdate = this.getGmtUpdate();
        result = result * 59 + ($gmtUpdate == null ? 43 : ((Object)$gmtUpdate).hashCode());
        return result;
    }

    public String toString() {
        return "Param(id=" + this.getId() + ", monitorId=" + this.getMonitorId() + ", field=" + this.getField() + ", paramValue=" + this.getParamValue() + ", type=" + this.getType() + ", gmtCreate=" + this.getGmtCreate() + ", gmtUpdate=" + this.getGmtUpdate() + ")";
    }

    public Param(Long id, Long monitorId, String field, String paramValue, byte type, LocalDateTime gmtCreate, LocalDateTime gmtUpdate) {
        this.id = id;
        this.monitorId = monitorId;
        this.field = field;
        this.paramValue = paramValue;
        this.type = type;
        this.gmtCreate = gmtCreate;
        this.gmtUpdate = gmtUpdate;
    }

    public Param() {
    }

    public static class ParamBuilder {
        private Long id;
        private Long monitorId;
        private String field;
        private String paramValue;
        private byte type;
        private LocalDateTime gmtCreate;
        private LocalDateTime gmtUpdate;

        ParamBuilder() {
        }

        public ParamBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public ParamBuilder monitorId(Long monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        public ParamBuilder field(String field) {
            this.field = field;
            return this;
        }

        public ParamBuilder paramValue(String paramValue) {
            this.paramValue = paramValue;
            return this;
        }

        public ParamBuilder type(byte type) {
            this.type = type;
            return this;
        }

        public ParamBuilder gmtCreate(LocalDateTime gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public ParamBuilder gmtUpdate(LocalDateTime gmtUpdate) {
            this.gmtUpdate = gmtUpdate;
            return this;
        }

        public Param build() {
            return new Param(this.id, this.monitorId, this.field, this.paramValue, this.type, this.gmtCreate, this.gmtUpdate);
        }

        public String toString() {
            return "Param.ParamBuilder(id=" + this.id + ", monitorId=" + this.monitorId + ", field=" + this.field + ", paramValue=" + this.paramValue + ", type=" + this.type + ", gmtCreate=" + this.gmtCreate + ", gmtUpdate=" + this.gmtUpdate + ")";
        }
    }
}

