/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.constants;

import java.util.Arrays;

public enum JexlKeywordsEnum {
    OR("or"),
    AND("and"),
    EQ("eq"),
    NE("ne"),
    LT("lt"),
    GT("gt"),
    LE("le"),
    GE("ge"),
    DIV("div"),
    MOD("mod"),
    NOT("not"),
    NULL("null"),
    TRUE("true"),
    FALSE("false"),
    NEW("new"),
    VAR("var"),
    DO("do"),
    WHILE("while"),
    BREAK("break"),
    CONTINUE("continue"),
    FUNCTION("function"),
    RETURN("return"),
    IF("if"),
    ELSE("else"),
    FOR("for"),
    SIZE("size"),
    EMPTY("empty");

    private final String keyword;

    private JexlKeywordsEnum(String keyword) {
        this.keyword = keyword;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public static boolean match(String word) {
        if (word == null || word.trim().isEmpty()) {
            return false;
        }
        return Arrays.stream(JexlKeywordsEnum.values()).anyMatch(t -> t.keyword.equals(word));
    }
}

