/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.transport;

import java.io.IOException;
import java.io.Serializable;
import java.util.TimerTask;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.smi.Address;
import org.snmp4j.transport.AbstractServerSocket;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;

public class SocketTimeout<A extends Address>
extends TimerTask {
    private static final LogAdapter logger = LogFactory.getLogger(SocketTimeout.class);
    private final ConnectionOrientedTransportMapping<A> transportMapping;
    private AbstractServerSocket<A> entry;

    public SocketTimeout(ConnectionOrientedTransportMapping<A> transportMapping, AbstractServerSocket<A> entry) {
        this.transportMapping = transportMapping;
        this.entry = entry;
    }

    @Override
    public void run() {
        long now = System.nanoTime();
        if (this.transportMapping.getSocketCleaner() == null || (now - this.entry.getLastUse()) / 1000000L >= this.transportMapping.getConnectionTimeout()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Socket has not been used for " + (now - this.entry.getLastUse()) + " milliseconds, closing it")));
            }
            AbstractServerSocket<A> entryCopy = this.entry;
            try {
                this.transportMapping.close(entryCopy.getPeerAddress());
                logger.info("Socket to " + entryCopy.getPeerAddress() + " closed due to timeout");
            }
            catch (IOException e) {
                logger.error("Failed to close transport mapping for peer address " + this.entry.getPeerAddress() + ": " + e.getMessage(), e);
            }
        } else {
            long nextRun = System.currentTimeMillis() + (now - this.entry.getLastUse()) / 1000000L + this.transportMapping.getConnectionTimeout();
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Scheduling " + nextRun)));
            }
            SocketTimeout<A> socketTimeout = new SocketTimeout<A>(this.transportMapping, this.entry);
            this.entry.setSocketTimeout(socketTimeout);
            this.transportMapping.getSocketCleaner().schedule(socketTimeout, nextRun);
        }
    }

    @Override
    public boolean cancel() {
        boolean result = super.cancel();
        this.entry = null;
        return result;
    }
}

