/*
 * Decompiled with CFR 0.152.
 */
package com.xugu.pool;

import com.xugu.pool.ConnectionWrapper;
import com.xugu.pool.XgConnectionEvent;
import com.xugu.pool.XgPooledConnection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;

public class XgConnectionEventListener
implements ConnectionEventListener {
    private XgPooledConnection xgcp = null;

    public XgConnectionEventListener() {
    }

    public XgConnectionEventListener(PooledConnection pooledConn) {
        this.xgcp = (XgPooledConnection)pooledConn;
    }

    @Override
    public void connectionClosed(ConnectionEvent event) {
        SQLException sqlE = null;
        XgConnectionEvent xgce = (XgConnectionEvent)event;
        try {
            ConnectionWrapper cw = xgce.getConnectionW();
            if (cw != null) {
                this.xgcp.freeConnection(cw);
                cw = null;
            }
            if ((sqlE = event.getSQLException()) != null) {
                throw sqlE;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent event) {
        SQLException sqlE = null;
        try {
            this.xgcp.errorClose();
            sqlE = event.getSQLException();
            if (sqlE != null) {
                throw sqlE;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

