/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class PlaceholderVisitor
extends ClassCodeVisitorSupport {
    private static final String PLACEHOLDER = "Underscore_Placeholder";
    private SourceUnit source;

    public PlaceholderVisitor(CompilationUnit compilationUnit, SourceUnit source) {
        this.source = source;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.source;
    }

    @Override
    public void visitDeclarationExpression(DeclarationExpression expression) {
        long underscoreCount;
        if (expression.isMultipleAssignmentDeclaration() && expression.getTupleExpression().getExpressions().size() > 1 && (underscoreCount = StreamSupport.stream(expression.getTupleExpression().spliterator(), false).map(e -> ((VariableExpression)e).getName()).filter(s -> "_".equals(s)).count()) > 1L) {
            expression.getTupleExpression().getExpressions().forEach(e -> {
                if ("_".equals(((VariableExpression)e).getName())) {
                    PlaceholderVisitor.markAsPlaceholder(e);
                }
            });
        }
        super.visitDeclarationExpression(expression);
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        long underscoreCount;
        if (expression.getParameters() != null && (underscoreCount = Arrays.stream(expression.getParameters()).map(Parameter::getName).filter(s -> "_".equals(s)).count()) > 1L) {
            for (Parameter param : expression.getParameters()) {
                if (!"_".equals(param.getName())) continue;
                PlaceholderVisitor.markAsPlaceholder(param);
            }
        }
        super.visitClosureExpression(expression);
    }

    private static void markAsPlaceholder(ASTNode node) {
        node.setNodeMetaData(PLACEHOLDER, Boolean.TRUE);
    }

    public static boolean isPlaceholder(ASTNode node) {
        return Boolean.TRUE.equals(node.getNodeMetaData(PLACEHOLDER));
    }
}

