/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.EnumConstantClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.StreamGroovyMethods;
import org.codehaus.groovy.syntax.SyntaxException;

public class EnumVisitor
extends ClassCodeVisitorSupport {
    private final SourceUnit sourceUnit;

    public EnumVisitor(CompilationUnit cu, SourceUnit su) {
        this.sourceUnit = su;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    public void visitClass(ClassNode node) {
        if (node.isEnum()) {
            this.completeEnum(node);
        }
    }

    private void completeEnum(ClassNode enumClass) {
        FieldNode minValue = null;
        FieldNode maxValue = null;
        FieldNode values = null;
        boolean isAIC = EnumVisitor.isAnonymousInnerClass(enumClass);
        if (!isAIC) {
            boolean isInnerClass;
            ClassNode enumPlain = enumClass.getPlainNodeReference();
            minValue = new FieldNode("MIN_VALUE", 25, enumPlain, enumClass, null);
            maxValue = new FieldNode("MAX_VALUE", 25, enumPlain, enumClass, null);
            values = new FieldNode("$VALUES", 4122, enumPlain.makeArray(), enumClass, null);
            values.setSynthetic(true);
            for (ConstructorNode ctor : enumClass.getDeclaredConstructors()) {
                ConstructorCallExpression ctorCall;
                if (ctor.isSyntheticPublic()) {
                    ctor.setSyntheticPublic(false);
                    ctor.setModifiers((ctor.getModifiers() | 2) & 0xFFFFFFFE);
                } else if (!ctor.isPrivate()) {
                    this.addError(ctor, "Illegal modifier for the enum constructor; only private is permitted.");
                }
                if (!ctor.firstStatementIsSpecialConstructorCall() || !(ctorCall = (ConstructorCallExpression)((ExpressionStatement)ctor.getFirstStatement()).getExpression()).isSuperCall()) continue;
                StringJoiner spec = new StringJoiner(",", enumClass.getNameWithoutPackage() + "(", ")");
                for (Parameter p : ctor.getParameters()) {
                    spec.add(p.getType().getUnresolvedName());
                }
                this.addError(ctorCall, "Cannot invoke super constructor from enum constructor " + spec);
            }
            boolean bl = isInnerClass = enumClass.getOuterClass() != null;
            if ((enumClass.getModifiers() & 0x410) != 0) {
                String name = enumClass.getNameWithoutPackage();
                String permitted = !isInnerClass ? "public is" : "public, private, protected & static are";
                this.addError(enumClass, "Illegal modifier for the enum " + name + "; only " + permitted + " permitted.");
            }
            EnumVisitor.addMethods(enumClass, values, minValue, maxValue);
            if (EnumVisitor.isAnyAbstract(enumClass)) {
                enumClass.setModifiers(enumClass.getModifiers() | 0x400);
            } else if (EnumVisitor.isNotExtended(enumClass)) {
                enumClass.setModifiers(enumClass.getModifiers() | 0x10);
            }
        }
        this.addInit(enumClass, minValue, maxValue, values, isAIC);
    }

    private static void addMethods(ClassNode enumClass, FieldNode values, FieldNode minValue, FieldNode maxValue) {
        VariableExpression ordinal;
        boolean hasNext = false;
        boolean hasPrevious = false;
        for (MethodNode methodNode : enumClass.getMethods()) {
            if ("next".equals(methodNode.getName()) && methodNode.getParameters().length == 0) {
                hasNext = true;
            }
            if ("previous".equals(methodNode.getName()) && methodNode.getParameters().length == 0) {
                hasPrevious = true;
            }
            if (!hasNext || !hasPrevious) continue;
            break;
        }
        boolean empty = true;
        for (FieldNode f : enumClass.getFields()) {
            if (!f.isEnum()) continue;
            empty = false;
            break;
        }
        ClassNode classNode = enumClass.getPlainNodeReference();
        MethodNode valuesMethod = new MethodNode("values", 25, classNode.makeArray(), Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
        valuesMethod.setSynthetic(true);
        MethodCallExpression cloneCall = GeneralUtils.callX(GeneralUtils.fieldX(values), "clone");
        cloneCall.setMethodTarget(values.getType().getMethod("clone", Parameter.EMPTY_ARRAY));
        valuesMethod.setCode(GeneralUtils.block(GeneralUtils.returnS(cloneCall)));
        ClassNodeUtils.addGeneratedMethod(enumClass, valuesMethod);
        if (!hasNext) {
            MethodNode nextMethod = new MethodNode("next", 1, classNode, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
            nextMethod.setSynthetic(true);
            ordinal = GeneralUtils.localVarX("ordinal", ClassHelper.int_TYPE);
            nextMethod.setCode(empty ? GeneralUtils.block(GeneralUtils.returnS(GeneralUtils.nullX())) : GeneralUtils.block(GeneralUtils.declS(ordinal, GeneralUtils.plusX(GeneralUtils.callThisX("ordinal"), GeneralUtils.constX(1, true))), GeneralUtils.ifS((Expression)GeneralUtils.geX(ordinal, GeneralUtils.propX((Expression)GeneralUtils.fieldX(values), "length")), GeneralUtils.returnS(GeneralUtils.varX(minValue))), GeneralUtils.returnS(GeneralUtils.indexX(GeneralUtils.fieldX(values), ordinal))));
            ClassNodeUtils.addGeneratedMethod(enumClass, nextMethod);
        }
        if (!hasPrevious) {
            MethodNode prevMethod = new MethodNode("previous", 1, classNode, Parameter.EMPTY_ARRAY, ClassNode.EMPTY_ARRAY, null);
            prevMethod.setSynthetic(true);
            ordinal = GeneralUtils.localVarX("ordinal", ClassHelper.int_TYPE);
            prevMethod.setCode(empty ? GeneralUtils.block(GeneralUtils.returnS(GeneralUtils.nullX())) : GeneralUtils.block(GeneralUtils.declS(ordinal, GeneralUtils.minusX(GeneralUtils.callThisX("ordinal"), GeneralUtils.constX(1, true))), GeneralUtils.ifS((Expression)GeneralUtils.ltX(ordinal, GeneralUtils.constX(0, true)), GeneralUtils.returnS(GeneralUtils.varX(maxValue))), GeneralUtils.returnS(GeneralUtils.indexX(GeneralUtils.fieldX(values), ordinal))));
            ClassNodeUtils.addGeneratedMethod(enumClass, prevMethod);
        }
        Parameter stringParameter = GeneralUtils.param(ClassHelper.STRING_TYPE, "name");
        MethodNode valueOfMethod = new MethodNode("valueOf", 9, classNode, GeneralUtils.params(stringParameter), ClassNode.EMPTY_ARRAY, null);
        valueOfMethod.setCode(GeneralUtils.block(GeneralUtils.returnS(GeneralUtils.callX(ClassHelper.Enum_Type, "valueOf", (Expression)GeneralUtils.args(GeneralUtils.classX(enumClass), GeneralUtils.varX("name"))))));
        valueOfMethod.setSynthetic(true);
        ClassNodeUtils.addGeneratedMethod(enumClass, valueOfMethod);
    }

    private void addInit(ClassNode enumClass, FieldNode minValue, FieldNode maxValue, FieldNode values, boolean isAIC) {
        ClassNode enumRef = enumClass.getPlainNodeReference();
        Parameter[] parameter = GeneralUtils.params(GeneralUtils.param(ClassHelper.OBJECT_TYPE.makeArray(), "para"));
        MethodNode initMethod = new MethodNode("$INIT", 4121, enumRef, parameter, ClassNode.EMPTY_ARRAY, null);
        initMethod.setSynthetic(true);
        ConstructorCallExpression cce = GeneralUtils.ctorThisX(GeneralUtils.args(GeneralUtils.spreadX(GeneralUtils.varX("para"))));
        initMethod.setCode(GeneralUtils.block(GeneralUtils.returnS(cce)));
        ClassNodeUtils.addGeneratedMethod(enumClass, initMethod);
        List<FieldNode> fields = enumClass.getFields();
        ArrayList<Expression> arrayInit = new ArrayList<Expression>();
        ArrayList<Statement> block = new ArrayList<Statement>();
        int index = -1;
        FieldNode tempMin = null;
        FieldNode tempMax = null;
        for (FieldNode field : fields) {
            if (!field.isEnum()) continue;
            ++index;
            if (tempMin == null) {
                tempMin = field;
            }
            tempMax = field;
            ClassNode enumType = enumClass;
            ArgumentListExpression args = GeneralUtils.args(GeneralUtils.constX(field.getName()), GeneralUtils.constX(index));
            if (field.getInitialExpression() == null) {
                if (enumClass.isAbstract()) {
                    this.addError(field, "The enum constant " + field.getName() + " must override abstract methods from " + enumClass.getName() + ".");
                }
                if (!ClassNodeUtils.hasNoArgConstructor(enumClass) && !enumClass.getDeclaredConstructors().isEmpty()) {
                    this.addError(field, "The constructor " + enumClass.getNameWithoutPackage() + "() is undefined.");
                }
            } else {
                ListExpression initList = (ListExpression)field.getInitialExpression();
                field.setInitialValueExpression(null);
                ArrayList<MapEntryExpression> savedMapEntries = new ArrayList<MapEntryExpression>();
                for (Expression exp : initList.getExpressions()) {
                    if (exp instanceof MapEntryExpression) {
                        savedMapEntries.add((MapEntryExpression)exp);
                        continue;
                    }
                    if (exp instanceof ClassExpression && exp.getType() instanceof EnumConstantClassNode) {
                        InnerClassNode inner = (InnerClassNode)exp.getType();
                        for (MethodNode methodNode : enumClass.getMethods()) {
                            MethodNode enumConstMethod;
                            if (!methodNode.isAbstract() || (enumConstMethod = inner.getMethod(methodNode.getName(), methodNode.getParameters())) != null && !enumConstMethod.isAbstract()) continue;
                            this.addError(field, "Can't have an abstract method in enum constant " + field.getName() + ". Implement method '" + methodNode.getTypeDescriptor(true) + "'.");
                        }
                        if (inner.getVariableScope() == null) {
                            enumType = inner;
                            initMethod.setModifiers(initMethod.getModifiers() & 0xFFFFFFEF);
                            continue;
                        }
                    }
                    args.addExpression(exp);
                }
                if (!savedMapEntries.isEmpty()) {
                    args.getExpressions().add(2, GeneralUtils.mapX(savedMapEntries));
                }
            }
            arrayInit.add(GeneralUtils.fieldX(field));
            block.add(GeneralUtils.assignS(GeneralUtils.fieldX(field), GeneralUtils.callX(enumType, "$INIT", (Expression)args)));
        }
        if (!isAIC) {
            if (tempMin != null) {
                block.add(GeneralUtils.assignS(GeneralUtils.fieldX(minValue), GeneralUtils.fieldX(tempMin)));
                block.add(GeneralUtils.assignS(GeneralUtils.fieldX(maxValue), GeneralUtils.fieldX(tempMax)));
                enumClass.addField(minValue);
                enumClass.addField(maxValue);
            }
            block.add(GeneralUtils.assignS(GeneralUtils.fieldX(values), GeneralUtils.arrayX(enumClass, arrayInit)));
            enumClass.addField(values);
        }
        enumClass.addStaticInitializerStatements(block, true);
    }

    private void addError(AnnotatedNode an, String msg) {
        this.getSourceUnit().getErrorCollector().addErrorAndContinue(new SyntaxErrorMessage(new SyntaxException(msg + "\n", an), this.getSourceUnit()));
    }

    static boolean isAnonymousInnerClass(ClassNode enumClass) {
        return enumClass instanceof EnumConstantClassNode && ((EnumConstantClassNode)enumClass).getVariableScope() == null;
    }

    private static boolean isAnyAbstract(ClassNode enumClass) {
        return enumClass.getMethods().stream().anyMatch(MethodNode::isAbstract);
    }

    private static boolean isNotExtended(ClassNode enumClass) {
        return StreamGroovyMethods.stream(enumClass.getInnerClasses()).noneMatch(it -> it instanceof EnumConstantClassNode);
    }
}

