/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc.trino;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.session.PropertyMetadata;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.HasPropertyMeta;
import org.apache.gravitino.trino.connector.catalog.jdbc.trino.TrinoClusterMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.jdbc.trino.TrinoClusterPropertyMeta;
import org.apache.gravitino.trino.connector.metadata.GravitinoCatalog;

public class TrinoClusterConnectorAdapter
implements CatalogConnectorAdapter {
    private static final String CONNECTOR_CLUSTER = "trino";
    public static final String TRINO_CLUSTER_URL_KEY = "cloud.trino.connection-url";
    public static final String TRINO_CLUSTER_USER_KEY = "cloud.trino.connection-user";
    public static final String TRINO_CLUSTER_PASSWORD_KEY = "cloud.trino.connection-password";
    public static final String TRINO_CLUSTER_DEFAULT_USER = "admin";
    private final HasPropertyMeta propertyMetadata = new TrinoClusterPropertyMeta();

    @Override
    public Map<String, String> buildInternalConnectorConfig(GravitinoCatalog catalog) {
        HashMap<String, String> config = new HashMap<String, String>();
        Object jdbcUrl = catalog.getProperty(TRINO_CLUSTER_URL_KEY, "");
        if (StringUtils.isEmpty((CharSequence)jdbcUrl)) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_CONFIG, "Missing jdbc url config for the cluster catalog");
        }
        jdbcUrl = (String)jdbcUrl + "/" + catalog.getName();
        config.put("connection-url", (String)jdbcUrl);
        String user = catalog.getProperty(TRINO_CLUSTER_USER_KEY, TRINO_CLUSTER_DEFAULT_USER);
        config.put("connection-user", user);
        String password = catalog.getProperty(TRINO_CLUSTER_PASSWORD_KEY, "");
        config.put("connection-password", password);
        return config;
    }

    @Override
    public String internalConnectorName() {
        return CONNECTOR_CLUSTER;
    }

    @Override
    public CatalogConnectorMetadataAdapter getMetadataAdapter() {
        return new TrinoClusterMetadataAdapter(this.getTableProperties(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public List<PropertyMetadata<?>> getTableProperties() {
        return this.propertyMetadata.getTablePropertyMetadata();
    }
}

