/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.service;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.gravitino.Entity;
import org.apache.gravitino.exceptions.NoSuchEntityException;
import org.apache.gravitino.meta.ColumnEntity;
import org.apache.gravitino.meta.TableEntity;
import org.apache.gravitino.metrics.MethodMonitorAspect;
import org.apache.gravitino.metrics.Monitored;
import org.apache.gravitino.metrics.source.MetricsSource;
import org.apache.gravitino.storage.relational.mapper.TableColumnMapper;
import org.apache.gravitino.storage.relational.po.ColumnPO;
import org.apache.gravitino.storage.relational.po.TablePO;
import org.apache.gravitino.storage.relational.utils.POConverters;
import org.apache.gravitino.storage.relational.utils.SessionUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public class TableColumnMetaService {
    private static final TableColumnMetaService INSTANCE;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ Annotation ajc$anno$0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ Annotation ajc$anno$1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ Annotation ajc$anno$2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ Annotation ajc$anno$3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ Annotation ajc$anno$4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ Annotation ajc$anno$5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static /* synthetic */ Annotation ajc$anno$6;

    private TableColumnMetaService() {
    }

    public static TableColumnMetaService getInstance() {
        return INSTANCE;
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getColumnsByTableIdAndVersion")
    List<ColumnPO> getColumnsByTableIdAndVersion(Long tableId, Long version) {
        Long l = tableId;
        Long l2 = version;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)l, (Object)l2);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$0;
        if (annotation == null) {
            annotation = ajc$anno$0 = TableColumnMetaService.class.getDeclaredMethod("getColumnsByTableIdAndVersion", Long.class, Long.class).getAnnotation(Monitored.class);
        }
        return (List)TableColumnMetaService.getColumnsByTableIdAndVersion_aroundBody1$advice(this, l, l2, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getColumnIdByTableIdAndName")
    public Long getColumnIdByTableIdAndName(Long tableId, String columnName) {
        Long l = tableId;
        String string = columnName;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)l, (Object)string);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$1;
        if (annotation == null) {
            annotation = ajc$anno$1 = TableColumnMetaService.class.getDeclaredMethod("getColumnIdByTableIdAndName", Long.class, String.class).getAnnotation(Monitored.class);
        }
        return (Long)TableColumnMetaService.getColumnIdByTableIdAndName_aroundBody3$advice(this, l, string, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="getColumnPOById")
    ColumnPO getColumnPOById(Long columnId) {
        Long l = columnId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)l);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$2;
        if (annotation == null) {
            annotation = ajc$anno$2 = TableColumnMetaService.class.getDeclaredMethod("getColumnPOById", Long.class).getAnnotation(Monitored.class);
        }
        return (ColumnPO)TableColumnMetaService.getColumnPOById_aroundBody5$advice(this, l, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="insertColumnPOs")
    void insertColumnPOs(TablePO tablePO, List<ColumnEntity> columnEntities) {
        TablePO tablePO2 = tablePO;
        List<ColumnEntity> list = columnEntities;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)tablePO2, list);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$3;
        if (annotation == null) {
            annotation = ajc$anno$3 = TableColumnMetaService.class.getDeclaredMethod("insertColumnPOs", TablePO.class, List.class).getAnnotation(Monitored.class);
        }
        TableColumnMetaService.insertColumnPOs_aroundBody7$advice(this, tablePO2, list, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteColumnsByTableId")
    boolean deleteColumnsByTableId(Long tableId) {
        Long l = tableId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)l);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$4;
        if (annotation == null) {
            annotation = ajc$anno$4 = TableColumnMetaService.class.getDeclaredMethod("deleteColumnsByTableId", Long.class).getAnnotation(Monitored.class);
        }
        return Conversions.booleanValue((Object)TableColumnMetaService.deleteColumnsByTableId_aroundBody9$advice(this, l, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="deleteColumnsByLegacyTimeline")
    public int deleteColumnsByLegacyTimeline(Long legacyTimeline, int limit) {
        Long l = legacyTimeline;
        int n = limit;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)l, (Object)Conversions.intObject((int)n));
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$5;
        if (annotation == null) {
            annotation = ajc$anno$5 = TableColumnMetaService.class.getDeclaredMethod("deleteColumnsByLegacyTimeline", Long.class, Integer.TYPE).getAnnotation(Monitored.class);
        }
        return Conversions.intValue((Object)TableColumnMetaService.deleteColumnsByLegacyTimeline_aroundBody11$advice(this, l, n, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation));
    }

    boolean isColumnUpdated(TableEntity oldTable, TableEntity newTable) {
        Map oldColumns = oldTable.columns() == null ? Collections.emptyMap() : oldTable.columns().stream().collect(Collectors.toMap(ColumnEntity::id, Function.identity()));
        Map newColumns = newTable.columns() == null ? Collections.emptyMap() : newTable.columns().stream().collect(Collectors.toMap(ColumnEntity::id, Function.identity()));
        return oldColumns.size() != newColumns.size() || !oldColumns.equals(newColumns);
    }

    @Monitored(metricsSource="gravitino-relational-store", baseMetricName="updateColumnPOsFromTableDiff")
    void updateColumnPOsFromTableDiff(TableEntity oldTable, TableEntity newTable, TablePO newTablePO) {
        TableEntity tableEntity = oldTable;
        TableEntity tableEntity2 = newTable;
        TablePO tablePO = newTablePO;
        Object[] objectArray = new Object[]{tableEntity, tableEntity2, tablePO};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        MethodMonitorAspect methodMonitorAspect = MethodMonitorAspect.aspectOf();
        ProceedingJoinPoint proceedingJoinPoint = (ProceedingJoinPoint)joinPoint;
        Annotation annotation = ajc$anno$6;
        if (annotation == null) {
            annotation = ajc$anno$6 = TableColumnMetaService.class.getDeclaredMethod("updateColumnPOsFromTableDiff", TableEntity.class, TableEntity.class, TablePO.class).getAnnotation(Monitored.class);
        }
        TableColumnMetaService.updateColumnPOsFromTableDiff_aroundBody13$advice(this, tableEntity, tableEntity2, tablePO, joinPoint, methodMonitorAspect, proceedingJoinPoint, (Monitored)annotation);
    }

    static {
        TableColumnMetaService.ajc$preClinit();
        INSTANCE = new TableColumnMetaService();
    }

    private static final /* synthetic */ List getColumnsByTableIdAndVersion_aroundBody0(TableColumnMetaService ajc$this, Long tableId, Long version, JoinPoint joinPoint) {
        List columnPOs = SessionUtils.getWithoutCommit(TableColumnMapper.class, mapper -> mapper.listColumnPOsByTableIdAndVersion(tableId, version));
        return columnPOs.stream().filter(c -> c.getColumnOpType().byteValue() != ColumnPO.ColumnOpType.DELETE.value()).collect(Collectors.toList());
    }

    private static final /* synthetic */ Object getColumnsByTableIdAndVersion_aroundBody1$advice(TableColumnMetaService ajc$this, Long tableId, Long version, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        List list;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableColumnMetaService.getColumnsByTableIdAndVersion_aroundBody0(ajc$this, tableId, version, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableColumnMetaService.getColumnsByTableIdAndVersion_aroundBody0(ajc$this, tableId, version, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                List result = TableColumnMetaService.getColumnsByTableIdAndVersion_aroundBody0(ajc$this, tableId, version, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                list = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return list;
    }

    private static final /* synthetic */ Long getColumnIdByTableIdAndName_aroundBody2(TableColumnMetaService ajc$this, Long tableId, String columnName, JoinPoint joinPoint) {
        Long columnId = SessionUtils.getWithoutCommit(TableColumnMapper.class, mapper -> mapper.selectColumnIdByTableIdAndName(tableId, columnName));
        if (columnId == null) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.COLUMN.name().toLowerCase(Locale.ROOT), columnName});
        }
        return columnId;
    }

    private static final /* synthetic */ Object getColumnIdByTableIdAndName_aroundBody3$advice(TableColumnMetaService ajc$this, Long tableId, String columnName, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Long l;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableColumnMetaService.getColumnIdByTableIdAndName_aroundBody2(ajc$this, tableId, columnName, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableColumnMetaService.getColumnIdByTableIdAndName_aroundBody2(ajc$this, tableId, columnName, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Long result = TableColumnMetaService.getColumnIdByTableIdAndName_aroundBody2(ajc$this, tableId, columnName, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                l = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return l;
    }

    private static final /* synthetic */ ColumnPO getColumnPOById_aroundBody4(TableColumnMetaService ajc$this, Long columnId, JoinPoint joinPoint) {
        ColumnPO columnPO = SessionUtils.getWithoutCommit(TableColumnMapper.class, mapper -> mapper.selectColumnPOById(columnId));
        if (columnPO == null || columnPO.getColumnOpType().byteValue() == ColumnPO.ColumnOpType.DELETE.value()) {
            throw new NoSuchEntityException("No such %s entity: %s", new Object[]{Entity.EntityType.COLUMN.name().toLowerCase(Locale.ROOT), columnId.toString()});
        }
        return columnPO;
    }

    private static final /* synthetic */ Object getColumnPOById_aroundBody5$advice(TableColumnMetaService ajc$this, Long columnId, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        ColumnPO columnPO;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableColumnMetaService.getColumnPOById_aroundBody4(ajc$this, columnId, (JoinPoint)proceedingJoinPoint);
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return TableColumnMetaService.getColumnPOById_aroundBody4(ajc$this, columnId, (JoinPoint)proceedingJoinPoint);
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                ColumnPO result = TableColumnMetaService.getColumnPOById_aroundBody4(ajc$this, columnId, (JoinPoint)proceedingJoinPoint);
                successMeter.mark();
                columnPO = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return columnPO;
    }

    private static final /* synthetic */ void insertColumnPOs_aroundBody6(TableColumnMetaService ajc$this, TablePO tablePO, List columnEntities, JoinPoint joinPoint) {
        List<ColumnPO> columnPOs = POConverters.initializeColumnPOs(tablePO, columnEntities, ColumnPO.ColumnOpType.CREATE);
        SessionUtils.doWithoutCommit(TableColumnMapper.class, mapper -> mapper.insertColumnPOs(columnPOs));
    }

    private static final /* synthetic */ Object insertColumnPOs_aroundBody7$advice(TableColumnMetaService ajc$this, TablePO tablePO, List columnEntities, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var14_19;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TableColumnMetaService.insertColumnPOs_aroundBody6(ajc$this, tablePO, columnEntities, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TableColumnMetaService.insertColumnPOs_aroundBody6(ajc$this, tablePO, columnEntities, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TableColumnMetaService.insertColumnPOs_aroundBody6(ajc$this, tablePO, columnEntities, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var14_19 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var14_19;
    }

    private static final /* synthetic */ boolean deleteColumnsByTableId_aroundBody8(TableColumnMetaService ajc$this, Long tableId, JoinPoint joinPoint) {
        Integer result = SessionUtils.getWithoutCommit(TableColumnMapper.class, mapper -> mapper.softDeleteColumnsByTableId(tableId));
        return result > 0;
    }

    private static final /* synthetic */ Object deleteColumnsByTableId_aroundBody9$advice(TableColumnMetaService ajc$this, Long tableId, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)TableColumnMetaService.deleteColumnsByTableId_aroundBody8(ajc$this, tableId, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.booleanObject((boolean)TableColumnMetaService.deleteColumnsByTableId_aroundBody8(ajc$this, tableId, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.booleanObject((boolean)TableColumnMetaService.deleteColumnsByTableId_aroundBody8(ajc$this, tableId, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ int deleteColumnsByLegacyTimeline_aroundBody10(TableColumnMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint joinPoint) {
        return SessionUtils.doWithCommitAndFetchResult(TableColumnMapper.class, mapper -> mapper.deleteColumnPOsByLegacyTimeline(legacyTimeline, limit));
    }

    private static final /* synthetic */ Object deleteColumnsByLegacyTimeline_aroundBody11$advice(TableColumnMetaService ajc$this, Long legacyTimeline, int limit, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object object;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)TableColumnMetaService.deleteColumnsByLegacyTimeline_aroundBody10(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                return Conversions.intObject((int)TableColumnMetaService.deleteColumnsByLegacyTimeline_aroundBody10(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                Object result = Conversions.intObject((int)TableColumnMetaService.deleteColumnsByLegacyTimeline_aroundBody10(ajc$this, legacyTimeline, limit, (JoinPoint)proceedingJoinPoint));
                successMeter.mark();
                object = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return object;
    }

    private static final /* synthetic */ void updateColumnPOsFromTableDiff_aroundBody12(TableColumnMetaService ajc$this, TableEntity oldTable, TableEntity newTable, TablePO newTablePO, JoinPoint joinPoint) {
        Map oldColumns = oldTable.columns() == null ? Collections.emptyMap() : oldTable.columns().stream().collect(Collectors.toMap(ColumnEntity::id, Function.identity()));
        Map newColumns = newTable.columns() == null ? Collections.emptyMap() : newTable.columns().stream().collect(Collectors.toMap(ColumnEntity::id, Function.identity()));
        ArrayList columnPOsToInsert = Lists.newArrayList();
        for (ColumnEntity newColumn : newColumns.values()) {
            ColumnEntity oldColumn = (ColumnEntity)oldColumns.get(newColumn.id());
            if (oldColumn != null && oldColumn.equals(newColumn)) continue;
            columnPOsToInsert.add(POConverters.initializeColumnPO(newTablePO, newColumn, ColumnPO.ColumnOpType.UPDATE));
        }
        for (ColumnEntity oldColumn : oldColumns.values()) {
            if (newColumns.containsKey(oldColumn.id())) continue;
            columnPOsToInsert.add(POConverters.initializeColumnPO(newTablePO, oldColumn, ColumnPO.ColumnOpType.DELETE));
        }
        if (columnPOsToInsert.isEmpty()) {
            if (!newTable.namespace().equals((Object)oldTable.namespace())) {
                SessionUtils.doWithoutCommit(TableColumnMapper.class, mapper -> mapper.updateSchemaIdByTableId(newTablePO.getTableId(), newTablePO.getSchemaId()));
            }
            return;
        }
        SessionUtils.doWithoutCommit(TableColumnMapper.class, mapper -> mapper.insertColumnPOs(columnPOsToInsert));
    }

    private static final /* synthetic */ Object updateColumnPOsFromTableDiff_aroundBody13$advice(TableColumnMetaService ajc$this, TableEntity oldTable, TableEntity newTable, TablePO newTablePO, JoinPoint thisJoinPoint, MethodMonitorAspect ajc$aspectInstance, ProceedingJoinPoint pjp, Monitored monitored) {
        Object var15_20;
        block10: {
            if (MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance) == null) {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TableColumnMetaService.updateColumnPOsFromTableDiff_aroundBody12(ajc$this, oldTable, newTable, newTablePO, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            MetricsSource metricsSource = MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$metricsSystem(ajc$aspectInstance).getMetricsSource(monitored.metricsSource());
            if (metricsSource == null) {
                MethodMonitorAspect.ajc$inlineAccessFieldGet$org_apache_gravitino_metrics_MethodMonitorAspect$org_apache_gravitino_metrics_MethodMonitorAspect$LOG().warn("MetricsSource {} is not registered in MetricsSystem, skip monitoring for method {}", (Object)monitored.metricsSource(), (Object)pjp.getSignature().toShortString());
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TableColumnMetaService.updateColumnPOsFromTableDiff_aroundBody12(ajc$this, oldTable, newTable, newTablePO, (JoinPoint)proceedingJoinPoint);
                return null;
            }
            String baseMetricName = monitored.baseMetricName();
            Timer timer = metricsSource.getTimer(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"total"}));
            Meter successMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"success"}));
            Meter failureMeter = metricsSource.getMeter(MetricRegistry.name((String)baseMetricName, (String[])new String[]{"failure"}));
            Timer.Context ignore = timer.time();
            try {
                ProceedingJoinPoint proceedingJoinPoint = pjp;
                TableColumnMetaService.updateColumnPOsFromTableDiff_aroundBody12(ajc$this, oldTable, newTable, newTablePO, (JoinPoint)proceedingJoinPoint);
                Object result = null;
                successMeter.mark();
                var15_20 = result;
                if (ignore == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (ignore != null) {
                        try {
                            ignore.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    failureMeter.mark();
                    throw t;
                }
            }
            ignore.close();
        }
        return var15_20;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("TableColumnMetaService.java", TableColumnMetaService.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getColumnsByTableIdAndVersion", "org.apache.gravitino.storage.relational.service.TableColumnMetaService", "java.lang.Long:java.lang.Long", "tableId:version", "", "java.util.List"), 55);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getColumnIdByTableIdAndName", "org.apache.gravitino.storage.relational.service.TableColumnMetaService", "java.lang.Long:java.lang.String", "tableId:columnName", "", "java.lang.Long"), 70);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "getColumnPOById", "org.apache.gravitino.storage.relational.service.TableColumnMetaService", "java.lang.Long", "columnId", "", "org.apache.gravitino.storage.relational.po.ColumnPO"), 89);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "insertColumnPOs", "org.apache.gravitino.storage.relational.service.TableColumnMetaService", "org.apache.gravitino.storage.relational.po.TablePO:java.util.List", "tablePO:columnEntities", "", "void"), 107);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "deleteColumnsByTableId", "org.apache.gravitino.storage.relational.service.TableColumnMetaService", "java.lang.Long", "tableId", "", "boolean"), 120);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteColumnsByLegacyTimeline", "org.apache.gravitino.storage.relational.service.TableColumnMetaService", "java.lang.Long:int", "legacyTimeline:limit", "", "int"), 130);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "updateColumnPOsFromTableDiff", "org.apache.gravitino.storage.relational.service.TableColumnMetaService", "org.apache.gravitino.meta.TableEntity:org.apache.gravitino.meta.TableEntity:org.apache.gravitino.storage.relational.po.TablePO", "oldTable:newTable:newTablePO", "", "void"), 157);
    }
}

