/*
 * Decompiled with CFR 0.152.
 */
package com.lancedb.lance.namespace.rest;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.lancedb.lance.namespace.LanceNamespace;
import com.lancedb.lance.namespace.LanceNamespaceException;
import com.lancedb.lance.namespace.ObjectIdentifier;
import com.lancedb.lance.namespace.client.apache.ApiClient;
import com.lancedb.lance.namespace.client.apache.ApiException;
import com.lancedb.lance.namespace.client.apache.api.NamespaceApi;
import com.lancedb.lance.namespace.client.apache.api.TableApi;
import com.lancedb.lance.namespace.client.apache.api.TransactionApi;
import com.lancedb.lance.namespace.lancedb.jackson.LanceNamespaceJacksonModule;
import com.lancedb.lance.namespace.model.AlterTransactionRequest;
import com.lancedb.lance.namespace.model.AlterTransactionResponse;
import com.lancedb.lance.namespace.model.CountTableRowsRequest;
import com.lancedb.lance.namespace.model.CreateEmptyTableRequest;
import com.lancedb.lance.namespace.model.CreateEmptyTableResponse;
import com.lancedb.lance.namespace.model.CreateNamespaceRequest;
import com.lancedb.lance.namespace.model.CreateNamespaceResponse;
import com.lancedb.lance.namespace.model.CreateTableIndexRequest;
import com.lancedb.lance.namespace.model.CreateTableIndexResponse;
import com.lancedb.lance.namespace.model.CreateTableRequest;
import com.lancedb.lance.namespace.model.CreateTableResponse;
import com.lancedb.lance.namespace.model.DeleteFromTableRequest;
import com.lancedb.lance.namespace.model.DeleteFromTableResponse;
import com.lancedb.lance.namespace.model.DeregisterTableRequest;
import com.lancedb.lance.namespace.model.DeregisterTableResponse;
import com.lancedb.lance.namespace.model.DescribeNamespaceRequest;
import com.lancedb.lance.namespace.model.DescribeNamespaceResponse;
import com.lancedb.lance.namespace.model.DescribeTableIndexStatsRequest;
import com.lancedb.lance.namespace.model.DescribeTableIndexStatsResponse;
import com.lancedb.lance.namespace.model.DescribeTableRequest;
import com.lancedb.lance.namespace.model.DescribeTableResponse;
import com.lancedb.lance.namespace.model.DescribeTransactionRequest;
import com.lancedb.lance.namespace.model.DescribeTransactionResponse;
import com.lancedb.lance.namespace.model.DropNamespaceRequest;
import com.lancedb.lance.namespace.model.DropNamespaceResponse;
import com.lancedb.lance.namespace.model.DropTableRequest;
import com.lancedb.lance.namespace.model.DropTableResponse;
import com.lancedb.lance.namespace.model.InsertIntoTableRequest;
import com.lancedb.lance.namespace.model.InsertIntoTableResponse;
import com.lancedb.lance.namespace.model.ListNamespacesRequest;
import com.lancedb.lance.namespace.model.ListNamespacesResponse;
import com.lancedb.lance.namespace.model.ListTableIndicesRequest;
import com.lancedb.lance.namespace.model.ListTableIndicesResponse;
import com.lancedb.lance.namespace.model.ListTablesRequest;
import com.lancedb.lance.namespace.model.ListTablesResponse;
import com.lancedb.lance.namespace.model.MergeInsertIntoTableRequest;
import com.lancedb.lance.namespace.model.MergeInsertIntoTableResponse;
import com.lancedb.lance.namespace.model.NamespaceExistsRequest;
import com.lancedb.lance.namespace.model.QueryTableRequest;
import com.lancedb.lance.namespace.model.RegisterTableRequest;
import com.lancedb.lance.namespace.model.RegisterTableResponse;
import com.lancedb.lance.namespace.model.TableExistsRequest;
import com.lancedb.lance.namespace.model.UpdateTableRequest;
import com.lancedb.lance.namespace.model.UpdateTableResponse;
import com.lancedb.lance.namespace.rest.RestNamespaceConfig;
import com.lancedb.lance.namespace.util.JsonUtil;
import java.util.Map;
import org.apache.arrow.memory.BufferAllocator;

public class RestNamespace
implements LanceNamespace {
    private NamespaceApi namespaceApi;
    private TableApi tableApi;
    private TransactionApi transactionApi;
    private RestNamespaceConfig config;

    @Override
    public void initialize(Map<String, String> configProperties, BufferAllocator allocator) {
        RestNamespaceConfig config = new RestNamespaceConfig(configProperties);
        ApiClient client = new ApiClient();
        if (config.getUri() != null) {
            client.setBasePath(config.getUri());
        }
        ObjectMapper objectMapper = client.getObjectMapper();
        objectMapper.registerModule((Module)new LanceNamespaceJacksonModule());
        client.setObjectMapper(objectMapper);
        this.initApiInstances(client, config);
    }

    protected void initApiInstances(ApiClient client, RestNamespaceConfig config) {
        this.config = config;
        this.namespaceApi = new NamespaceApi(client);
        this.tableApi = new TableApi(client);
        this.transactionApi = new TransactionApi(client);
    }

    @Override
    public String namespaceId() {
        String uri = this.config.getUri() != null ? this.config.getUri() : "";
        String delimiter = this.config.getDelimiter();
        return String.format("RestNamespace { endpoint: \"%s\", delimiter: \"%s\" }", uri, delimiter);
    }

    @Override
    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest request) {
        try {
            return this.namespaceApi.createNamespace(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public ListNamespacesResponse listNamespaces(ListNamespacesRequest request) {
        try {
            return this.namespaceApi.listNamespaces(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), this.config.getDelimiter(), request.getPageToken(), request.getLimit(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public DescribeNamespaceResponse describeNamespace(DescribeNamespaceRequest request) {
        try {
            return this.namespaceApi.describeNamespace(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public DropNamespaceResponse dropNamespace(DropNamespaceRequest request) {
        try {
            return this.namespaceApi.dropNamespace(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public void namespaceExists(NamespaceExistsRequest request) {
        try {
            this.namespaceApi.namespaceExists(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public DescribeTableResponse describeTable(DescribeTableRequest request) {
        try {
            return this.tableApi.describeTable(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public Long countTableRows(CountTableRowsRequest request) {
        try {
            return this.tableApi.countTableRows(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public CreateTableResponse createTable(CreateTableRequest request, byte[] requestData) {
        try {
            String serializedTableProperties = JsonUtil.generate(gen -> JsonUtil.writeStringMap(request.getProperties(), gen), false);
            return this.tableApi.createTable(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), requestData, this.config.getDelimiter(), request.getMode() == null ? null : request.getMode().getValue(), request.getLocation(), serializedTableProperties, this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public CreateEmptyTableResponse createEmptyTable(CreateEmptyTableRequest request) {
        try {
            return this.tableApi.createEmptyTable(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public InsertIntoTableResponse insertIntoTable(InsertIntoTableRequest request, byte[] requestData) {
        try {
            String modeStr = request.getMode() == null ? null : request.getMode().getValue();
            return this.tableApi.insertIntoTable(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), requestData, this.config.getDelimiter(), modeStr, this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public MergeInsertIntoTableResponse mergeInsertIntoTable(MergeInsertIntoTableRequest request, byte[] requestData) {
        try {
            return this.tableApi.mergeInsertIntoTable(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request.getOn(), requestData, this.config.getDelimiter(), request.getWhenMatchedUpdateAll(), request.getWhenMatchedUpdateAllFilt(), request.getWhenNotMatchedInsertAll(), request.getWhenNotMatchedBySourceDelete(), request.getWhenNotMatchedBySourceDeleteFilt(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public UpdateTableResponse updateTable(UpdateTableRequest request) {
        try {
            return this.tableApi.updateTable(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public DeleteFromTableResponse deleteFromTable(DeleteFromTableRequest request) {
        try {
            return this.tableApi.deleteFromTable(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public byte[] queryTable(QueryTableRequest request) {
        try {
            return this.tableApi.queryTable(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public ListTablesResponse listTables(ListTablesRequest request) {
        try {
            return this.tableApi.listTables(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), this.config.getDelimiter(), request.getPageToken(), request.getLimit(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public CreateTableIndexResponse createTableIndex(CreateTableIndexRequest request) {
        try {
            return this.tableApi.createTableIndex(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public ListTableIndicesResponse listTableIndices(ListTableIndicesRequest request) {
        try {
            return this.tableApi.listTableIndices(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public DescribeTableIndexStatsResponse describeTableIndexStats(DescribeTableIndexStatsRequest request, String indexName) {
        try {
            return this.tableApi.describeTableIndexStats(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), indexName, request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public RegisterTableResponse registerTable(RegisterTableRequest request) {
        try {
            return this.tableApi.registerTable(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public void tableExists(TableExistsRequest request) {
        try {
            this.tableApi.tableExists(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public DeregisterTableResponse deregisterTable(DeregisterTableRequest request) {
        try {
            return this.tableApi.deregisterTable(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public DropTableResponse dropTable(DropTableRequest request) {
        try {
            return this.tableApi.dropTable(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public AlterTransactionResponse alterTransaction(AlterTransactionRequest request) {
        try {
            return this.transactionApi.alterTransaction(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }

    @Override
    public DescribeTransactionResponse describeTransaction(DescribeTransactionRequest request) {
        try {
            return this.transactionApi.describeTransaction(ObjectIdentifier.of(request.getId()).stringStyleId(this.config.getDelimiter()), request, this.config.getDelimiter(), this.config.getAdditionalHeaders());
        }
        catch (ApiException e) {
            throw new LanceNamespaceException(e);
        }
    }
}

