/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.com.squareup.okhttp.internal;

import android.util.Log;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.hadoop.shaded.com.squareup.okhttp.Protocol;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.Internal;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.OptionalMethod;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.Util;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.tls.AndroidTrustRootIndex;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.tls.RealTrustRootIndex;
import org.apache.hadoop.shaded.com.squareup.okhttp.internal.tls.TrustRootIndex;
import org.apache.hadoop.shaded.okio.Buffer;

public class Platform {
    private static final Platform PLATFORM = Platform.findPlatform();

    public static Platform get() {
        return PLATFORM;
    }

    public String getPrefix() {
        return "OkHttp";
    }

    public void logW(String warning) {
        System.out.println(warning);
    }

    public void tagSocket(Socket socket) throws SocketException {
    }

    public void untagSocket(Socket socket) throws SocketException {
    }

    public X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
        return null;
    }

    public TrustRootIndex trustRootIndex(X509TrustManager trustManager) {
        return new RealTrustRootIndex(trustManager.getAcceptedIssuers());
    }

    public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
    }

    public void afterHandshake(SSLSocket sslSocket) {
    }

    public String getSelectedProtocol(SSLSocket socket) {
        return null;
    }

    public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
        socket.connect(address, connectTimeout);
    }

    public void log(String message) {
        System.out.println(message);
    }

    private static Platform findPlatform() {
        try {
            Class<?> sslParametersClass;
            try {
                sslParametersClass = Class.forName("org.apache.hadoop.shaded.com.android.org.conscrypt.SSLParametersImpl");
            }
            catch (ClassNotFoundException e) {
                sslParametersClass = Class.forName("org.apache.hadoop.shaded.org.apache.harmony.xnet.provider.jsse.SSLParametersImpl");
            }
            OptionalMethod<Socket> setUseSessionTickets = new OptionalMethod<Socket>(null, "setUseSessionTickets", Boolean.TYPE);
            OptionalMethod<Socket> setHostname = new OptionalMethod<Socket>(null, "setHostname", String.class);
            Method trafficStatsTagSocket = null;
            Method trafficStatsUntagSocket = null;
            OptionalMethod getAlpnSelectedProtocol = null;
            OptionalMethod setAlpnProtocols = null;
            try {
                Class<?> trafficStats = Class.forName("android.net.TrafficStats");
                trafficStatsTagSocket = trafficStats.getMethod("tagSocket", Socket.class);
                trafficStatsUntagSocket = trafficStats.getMethod("untagSocket", Socket.class);
                try {
                    Class.forName("android.net.Network");
                    getAlpnSelectedProtocol = new OptionalMethod(byte[].class, "getAlpnSelectedProtocol", new Class[0]);
                    setAlpnProtocols = new OptionalMethod(null, "setAlpnProtocols", byte[].class);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            catch (ClassNotFoundException | NoSuchMethodException trafficStats) {
                // empty catch block
            }
            return new Android(sslParametersClass, setUseSessionTickets, setHostname, trafficStatsTagSocket, trafficStatsUntagSocket, getAlpnSelectedProtocol, setAlpnProtocols);
        }
        catch (ClassNotFoundException sslParametersClass) {
            try {
                Class<?> sslContextClass = Class.forName("sun.security.ssl.SSLContextImpl");
                try {
                    String negoClassName = "org.apache.hadoop.shaded.org.eclipse.jetty.alpn.ALPN";
                    Class<?> negoClass = Class.forName(negoClassName);
                    Class<?> providerClass = Class.forName(negoClassName + "$Provider");
                    Class<?> clientProviderClass = Class.forName(negoClassName + "$ClientProvider");
                    Class<?> serverProviderClass = Class.forName(negoClassName + "$ServerProvider");
                    Method putMethod = negoClass.getMethod("put", SSLSocket.class, providerClass);
                    Method getMethod = negoClass.getMethod("get", SSLSocket.class);
                    Method removeMethod = negoClass.getMethod("remove", SSLSocket.class);
                    return new JdkWithJettyBootPlatform(sslContextClass, putMethod, getMethod, removeMethod, clientProviderClass, serverProviderClass);
                }
                catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                    return new JdkPlatform(sslContextClass);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                return new Platform();
            }
        }
    }

    static byte[] concatLengthPrefixed(List<Protocol> protocols) {
        Buffer result = new Buffer();
        int size = protocols.size();
        for (int i = 0; i < size; ++i) {
            Protocol protocol = protocols.get(i);
            if (protocol == Protocol.HTTP_1_0) continue;
            result.writeByte(protocol.toString().length());
            result.writeUtf8(protocol.toString());
        }
        return result.readByteArray();
    }

    static <T> T readFieldOrNull(Object instance, Class<T> fieldType, String fieldName) {
        Object delegate;
        for (Class<?> c = instance.getClass(); c != Object.class; c = c.getSuperclass()) {
            try {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                Object value = field.get(instance);
                if (value == null || !fieldType.isInstance(value)) {
                    return null;
                }
                return fieldType.cast(value);
            }
            catch (NoSuchFieldException field) {
                continue;
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
        }
        if (!fieldName.equals("delegate") && (delegate = Platform.readFieldOrNull(instance, Object.class, "delegate")) != null) {
            return Platform.readFieldOrNull(delegate, fieldType, fieldName);
        }
        return null;
    }

    private static class JettyNegoProvider
    implements InvocationHandler {
        private final List<String> protocols;
        private boolean unsupported;
        private String selected;

        public JettyNegoProvider(List<String> protocols) {
            this.protocols = protocols;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            Class<?> returnType = method.getReturnType();
            if (args == null) {
                args = Util.EMPTY_STRING_ARRAY;
            }
            if (methodName.equals("supports") && Boolean.TYPE == returnType) {
                return true;
            }
            if (methodName.equals("unsupported") && Void.TYPE == returnType) {
                this.unsupported = true;
                return null;
            }
            if (methodName.equals("protocols") && args.length == 0) {
                return this.protocols;
            }
            if ((methodName.equals("selectProtocol") || methodName.equals("select")) && String.class == returnType && args.length == 1 && args[0] instanceof List) {
                List peerProtocols = (List)args[0];
                int size = peerProtocols.size();
                for (int i = 0; i < size; ++i) {
                    if (!this.protocols.contains(peerProtocols.get(i))) continue;
                    this.selected = (String)peerProtocols.get(i);
                    return this.selected;
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((methodName.equals("protocolSelected") || methodName.equals("selected")) && args.length == 1) {
                this.selected = (String)args[0];
                return null;
            }
            return method.invoke((Object)this, args);
        }
    }

    private static class JdkWithJettyBootPlatform
    extends JdkPlatform {
        private final Method putMethod;
        private final Method getMethod;
        private final Method removeMethod;
        private final Class<?> clientProviderClass;
        private final Class<?> serverProviderClass;

        public JdkWithJettyBootPlatform(Class<?> sslContextClass, Method putMethod, Method getMethod, Method removeMethod, Class<?> clientProviderClass, Class<?> serverProviderClass) {
            super(sslContextClass);
            this.putMethod = putMethod;
            this.getMethod = getMethod;
            this.removeMethod = removeMethod;
            this.clientProviderClass = clientProviderClass;
            this.serverProviderClass = serverProviderClass;
        }

        @Override
        public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
            ArrayList<String> names = new ArrayList<String>(protocols.size());
            int size = protocols.size();
            for (int i = 0; i < size; ++i) {
                Protocol protocol = protocols.get(i);
                if (protocol == Protocol.HTTP_1_0) continue;
                names.add(protocol.toString());
            }
            try {
                Object provider = Proxy.newProxyInstance(Platform.class.getClassLoader(), new Class[]{this.clientProviderClass, this.serverProviderClass}, (InvocationHandler)new JettyNegoProvider(names));
                this.putMethod.invoke(null, sslSocket, provider);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AssertionError((Object)e);
            }
        }

        @Override
        public void afterHandshake(SSLSocket sslSocket) {
            try {
                this.removeMethod.invoke(null, sslSocket);
            }
            catch (IllegalAccessException | InvocationTargetException ignored) {
                throw new AssertionError();
            }
        }

        @Override
        public String getSelectedProtocol(SSLSocket socket) {
            try {
                JettyNegoProvider provider = (JettyNegoProvider)Proxy.getInvocationHandler(this.getMethod.invoke(null, socket));
                if (!provider.unsupported && provider.selected == null) {
                    Internal.logger.log(Level.INFO, "ALPN callback dropped: SPDY and HTTP/2 are disabled. Is alpn-boot on the boot class path?");
                    return null;
                }
                return provider.unsupported ? null : provider.selected;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new AssertionError();
            }
        }
    }

    private static class JdkPlatform
    extends Platform {
        private final Class<?> sslContextClass;

        public JdkPlatform(Class<?> sslContextClass) {
            this.sslContextClass = sslContextClass;
        }

        @Override
        public X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
            Object context = JdkPlatform.readFieldOrNull(sslSocketFactory, this.sslContextClass, "context");
            if (context == null) {
                return null;
            }
            return JdkPlatform.readFieldOrNull(context, X509TrustManager.class, "trustManager");
        }
    }

    private static class Android
    extends Platform {
        private static final int MAX_LOG_LENGTH = 4000;
        private final Class<?> sslParametersClass;
        private final OptionalMethod<Socket> setUseSessionTickets;
        private final OptionalMethod<Socket> setHostname;
        private final Method trafficStatsTagSocket;
        private final Method trafficStatsUntagSocket;
        private final OptionalMethod<Socket> getAlpnSelectedProtocol;
        private final OptionalMethod<Socket> setAlpnProtocols;

        public Android(Class<?> sslParametersClass, OptionalMethod<Socket> setUseSessionTickets, OptionalMethod<Socket> setHostname, Method trafficStatsTagSocket, Method trafficStatsUntagSocket, OptionalMethod<Socket> getAlpnSelectedProtocol, OptionalMethod<Socket> setAlpnProtocols) {
            this.sslParametersClass = sslParametersClass;
            this.setUseSessionTickets = setUseSessionTickets;
            this.setHostname = setHostname;
            this.trafficStatsTagSocket = trafficStatsTagSocket;
            this.trafficStatsUntagSocket = trafficStatsUntagSocket;
            this.getAlpnSelectedProtocol = getAlpnSelectedProtocol;
            this.setAlpnProtocols = setAlpnProtocols;
        }

        @Override
        public void connectSocket(Socket socket, InetSocketAddress address, int connectTimeout) throws IOException {
            try {
                socket.connect(address, connectTimeout);
            }
            catch (AssertionError e) {
                if (Util.isAndroidGetsocknameError(e)) {
                    throw new IOException((Throwable)((Object)e));
                }
                throw e;
            }
            catch (SecurityException e) {
                IOException ioException = new IOException("Exception in connect");
                ioException.initCause(e);
                throw ioException;
            }
        }

        @Override
        public X509TrustManager trustManager(SSLSocketFactory sslSocketFactory) {
            X509TrustManager x509TrustManager;
            Object context = Android.readFieldOrNull(sslSocketFactory, this.sslParametersClass, "sslParameters");
            if (context == null) {
                try {
                    Class<?> gmsSslParametersClass = Class.forName("org.apache.hadoop.shaded.com.google.android.gms.org.conscrypt.SSLParametersImpl", false, sslSocketFactory.getClass().getClassLoader());
                    context = Android.readFieldOrNull(sslSocketFactory, gmsSslParametersClass, "sslParameters");
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
            if ((x509TrustManager = Android.readFieldOrNull(context, X509TrustManager.class, "x509TrustManager")) != null) {
                return x509TrustManager;
            }
            return Android.readFieldOrNull(context, X509TrustManager.class, "trustManager");
        }

        @Override
        public TrustRootIndex trustRootIndex(X509TrustManager trustManager) {
            TrustRootIndex result = AndroidTrustRootIndex.get(trustManager);
            if (result != null) {
                return result;
            }
            return super.trustRootIndex(trustManager);
        }

        @Override
        public void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<Protocol> protocols) {
            if (hostname != null) {
                this.setUseSessionTickets.invokeOptionalWithoutCheckedException(sslSocket, true);
                this.setHostname.invokeOptionalWithoutCheckedException(sslSocket, hostname);
            }
            if (this.setAlpnProtocols != null && this.setAlpnProtocols.isSupported(sslSocket)) {
                Object[] parameters = new Object[]{Android.concatLengthPrefixed(protocols)};
                this.setAlpnProtocols.invokeWithoutCheckedException(sslSocket, parameters);
            }
        }

        @Override
        public String getSelectedProtocol(SSLSocket socket) {
            if (this.getAlpnSelectedProtocol == null) {
                return null;
            }
            if (!this.getAlpnSelectedProtocol.isSupported(socket)) {
                return null;
            }
            byte[] alpnResult = (byte[])this.getAlpnSelectedProtocol.invokeWithoutCheckedException(socket, new Object[0]);
            return alpnResult != null ? new String(alpnResult, Util.UTF_8) : null;
        }

        @Override
        public void tagSocket(Socket socket) throws SocketException {
            if (this.trafficStatsTagSocket == null) {
                return;
            }
            try {
                this.trafficStatsTagSocket.invoke(null, socket);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }

        @Override
        public void untagSocket(Socket socket) throws SocketException {
            if (this.trafficStatsUntagSocket == null) {
                return;
            }
            try {
                this.trafficStatsUntagSocket.invoke(null, socket);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }

        @Override
        public void log(String message) {
            int length = message.length();
            for (int i = 0; i < length; ++i) {
                int end;
                int newline = message.indexOf(10, i);
                newline = newline != -1 ? newline : length;
                do {
                    end = Math.min(newline, i + 4000);
                    Log.d((String)"OkHttp", (String)message.substring(i, end));
                } while ((i = end) < newline);
            }
        }
    }
}

