/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.util.Map;
import org.apache.iceberg.aws.AwsClientFactory;
import org.apache.iceberg.aws.S3FileIOAwsClientFactories;
import org.apache.iceberg.aws.s3.AnalyticsAcceleratorUtil;
import org.apache.iceberg.aws.s3.S3FileIOAwsClientFactory;
import org.apache.iceberg.aws.s3.S3FileIOProperties;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.base.Strings;
import org.apache.iceberg.util.SerializableSupplier;
import software.amazon.awssdk.services.s3.S3AsyncClient;
import software.amazon.awssdk.services.s3.S3Client;

class PrefixedS3Client
implements AutoCloseable {
    private final String storagePrefix;
    private final S3FileIOProperties s3FileIOProperties;
    private SerializableSupplier<S3Client> s3;
    private SerializableSupplier<S3AsyncClient> s3Async;
    private volatile transient S3Client s3Client;
    private volatile transient S3AsyncClient s3AsyncClient;

    PrefixedS3Client(String storagePrefix, Map<String, String> properties, SerializableSupplier<S3Client> s3, SerializableSupplier<S3AsyncClient> s3Async) {
        Object clientFactory;
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)storagePrefix) ? 1 : 0) != 0, (Object)"Invalid storage prefix: null or empty");
        Preconditions.checkArgument((null != properties ? 1 : 0) != 0, (Object)"Invalid properties: null");
        this.storagePrefix = storagePrefix;
        this.s3 = s3;
        this.s3Async = s3Async;
        this.s3FileIOProperties = new S3FileIOProperties(properties);
        if (s3 == null) {
            clientFactory = S3FileIOAwsClientFactories.initialize(properties);
            if (clientFactory instanceof S3FileIOAwsClientFactory) {
                this.s3 = ((S3FileIOAwsClientFactory)clientFactory)::s3;
            }
            if (clientFactory instanceof AwsClientFactory) {
                this.s3 = ((AwsClientFactory)clientFactory)::s3;
            }
            if (this.s3FileIOProperties.isPreloadClientEnabled()) {
                this.s3();
            }
        }
        if (s3Async == null) {
            clientFactory = S3FileIOAwsClientFactories.initialize(properties);
            if (clientFactory instanceof S3FileIOAwsClientFactory) {
                this.s3Async = ((S3FileIOAwsClientFactory)clientFactory)::s3Async;
            }
            if (clientFactory instanceof AwsClientFactory) {
                this.s3Async = ((AwsClientFactory)clientFactory)::s3Async;
            }
        }
    }

    public String storagePrefix() {
        return this.storagePrefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3Client s3() {
        if (this.s3Client == null) {
            PrefixedS3Client prefixedS3Client = this;
            synchronized (prefixedS3Client) {
                if (this.s3Client == null) {
                    this.s3Client = (S3Client)this.s3.get();
                }
            }
        }
        return this.s3Client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public S3AsyncClient s3Async() {
        if (this.s3AsyncClient == null) {
            PrefixedS3Client prefixedS3Client = this;
            synchronized (prefixedS3Client) {
                if (this.s3AsyncClient == null) {
                    this.s3AsyncClient = (S3AsyncClient)this.s3Async.get();
                }
            }
        }
        return this.s3AsyncClient;
    }

    public S3FileIOProperties s3FileIOProperties() {
        return this.s3FileIOProperties;
    }

    @Override
    public void close() {
        if (null != this.s3Client) {
            this.s3Client.close();
        }
        if (null != this.s3AsyncClient) {
            if (this.s3FileIOProperties().isS3AnalyticsAcceleratorEnabled()) {
                AnalyticsAcceleratorUtil.cleanupCache(this.s3AsyncClient, this.s3FileIOProperties);
            }
            this.s3AsyncClient.close();
        }
    }
}

