/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.aviator;

import com.googlecode.aviator.AviatorEvaluatorInstance;
import com.googlecode.aviator.BaseExpression;
import com.googlecode.aviator.Expression;
import com.googlecode.aviator.code.interpreter.IR;
import com.googlecode.aviator.code.interpreter.InterpretContext;
import com.googlecode.aviator.code.interpreter.ir.LoadIR;
import com.googlecode.aviator.lexer.SymbolTable;
import com.googlecode.aviator.lexer.token.Token;
import com.googlecode.aviator.parser.VariableMeta;
import com.googlecode.aviator.runtime.LambdaFunctionBootstrap;
import com.googlecode.aviator.runtime.RuntimeUtils;
import com.googlecode.aviator.runtime.type.AviatorJavaType;
import com.googlecode.aviator.runtime.type.AviatorObject;
import com.googlecode.aviator.utils.Env;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InterpretExpression
extends BaseExpression {
    private static final long serialVersionUID = -3831400781523526582L;
    private List<IR> instruments;
    private boolean unboxObject;
    private Map<VariableMeta, AviatorJavaType> variables = new IdentityHashMap<VariableMeta, AviatorJavaType>();
    private Map<Token<?>, AviatorObject> constantPool = new IdentityHashMap();

    public InterpretExpression(AviatorEvaluatorInstance instance, List<VariableMeta> vars, Set<Token<?>> constants, SymbolTable symbolTable, List<IR> instruments, boolean unboxObject) {
        super(instance, vars, symbolTable);
        this.instruments = instruments;
        this.unboxObject = unboxObject;
        this.loadVars(vars);
        this.loadConstants(constants, instruments);
    }

    private void loadVars(List<VariableMeta> vars) {
        for (VariableMeta v : vars) {
            this.variables.put(v, new AviatorJavaType(v.getName(), this.symbolTable));
        }
    }

    private void loadConstants(Set<Token<?>> constants, List<IR> instruments) {
        Env env = new Env();
        env.setInstance(this.instance);
        InterpretContext ctx = new InterpretContext(this, instruments, env);
        for (Token<?> token : constants) {
            LoadIR loadConstantIR = new LoadIR(this.sourceFile, token, null, false);
            loadConstantIR.evalWithoutDispatch(ctx);
            this.constantPool.put(token, ctx.pop());
        }
    }

    public AviatorJavaType loadVar(VariableMeta v) {
        return this.variables.get(v);
    }

    public AviatorObject loadConstant(Token<?> token) {
        return this.constantPool.get(token);
    }

    public void printInstruments() {
        this.traceInstruments(Collections.emptyMap(), null, true);
    }

    private void traceInstruments(Map<String, Object> env, String name, boolean traceLambda) {
        int pc = 0;
        RuntimeUtils.printlnTrace(env, (name == null ? this.sourceFile : name) + " instruments: ");
        for (IR ir : this.instruments) {
            RuntimeUtils.printlnTrace(env, "    " + pc++ + " " + ir.toString());
        }
        RuntimeUtils.printlnTrace(env, "    " + pc + " return");
        if (this.lambdaBootstraps != null) {
            ArrayList bootstraps = new ArrayList(this.lambdaBootstraps.values());
            Collections.sort(bootstraps);
            for (LambdaFunctionBootstrap bootstrap : bootstraps) {
                Expression exp = bootstrap.getExpression();
                if (exp instanceof InterpretExpression) {
                    InterpretExpression iexp = (InterpretExpression)exp;
                    iexp.traceInstruments(env, bootstrap.getName(), traceLambda);
                    continue;
                }
                RuntimeUtils.printlnTrace(env, bootstrap.getName() + " instruments: " + exp);
            }
        }
    }

    @Override
    public Object executeDirectly(Map<String, Object> env) {
        boolean trace = RuntimeUtils.isTracedEval(env);
        if (trace) {
            this.traceInstruments(env, null, false);
            RuntimeUtils.printlnTrace(env, "Execute instruments: ");
        }
        InterpretContext ctx = new InterpretContext(this, this.instruments, (Env)env);
        ctx.dispatch(false);
        if (trace) {
            RuntimeUtils.printlnTrace(env, "    return    " + ctx.descOperandsStack());
        }
        assert (ctx.getOperands().size() <= 1);
        AviatorObject result = ctx.peek();
        if (result == null) {
            return null;
        }
        if (this.unboxObject) {
            return result.getValue(env);
        }
        return result.deref(env);
    }

    private void readObject(ObjectInputStream input) throws ClassNotFoundException, IOException {
        super.customReadObject(input);
        this.instruments = (List)input.readObject();
        this.unboxObject = input.readBoolean();
        this.variables = (Map)input.readObject();
        this.constantPool = (Map)input.readObject();
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        super.customWriteObject(output);
        output.writeObject(this.instruments);
        output.writeBoolean(this.unboxObject);
        output.writeObject(this.variables);
        output.writeObject(this.constantPool);
    }
}

