/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.bidimap.TreeBidiMap;
import org.apache.gravitino.trino.connector.catalog.CatalogPropertyConverter;

public class JDBCCatalogPropertyConverter
extends CatalogPropertyConverter {
    public static final String JDBC_CONNECTION_URL_KEY = "connection-url";
    public static final String JDBC_CONNECTION_USER_KEY = "connection-user";
    public static final String JDBC_CONNECTION_PASSWORD_KEY = "connection-password";
    private static final TreeBidiMap<String, String> TRINO_KEY_TO_GRAVITINO_KEY = new TreeBidiMap((Map)new ImmutableMap.Builder().put((Object)"connection-url", (Object)"jdbc-url").put((Object)"connection-user", (Object)"jdbc-user").put((Object)"connection-password", (Object)"jdbc-password").build());
    public static final Set<String> REQUIRED_PROPERTIES = Sets.newHashSet((Object[])new String[]{"connection-url", "connection-user", "connection-password"});

    public TreeBidiMap<String, String> engineToGravitinoMapping() {
        return TRINO_KEY_TO_GRAVITINO_KEY;
    }

    @Override
    public Map<String, String> gravitinoToEngineProperties(Map<String, String> properties) {
        Map<String, String> trinoProperties = super.gravitinoToEngineProperties(properties);
        for (String requiredProperty : REQUIRED_PROPERTIES) {
            if (trinoProperties.containsKey(requiredProperty)) continue;
            throw new IllegalArgumentException("Missing required property: " + requiredProperty);
        }
        return trinoProperties;
    }
}

