/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;

public class GravitinoConfig {
    private static final String TRINO_DISCOVERY_URI = "discovery.uri";
    private static final String TRINO_CATALOG_CONFIG_DIR = "catalog.config-dir";
    public static final String TRINO_PLUGIN_BUNDLES = "plugin.bundles";
    public static final String TRINO_CATALOG_STORE = "catalog.store";
    public static final String TRINO_CATALOG_MANAGEMENT = "catalog.management";
    private static final String TRINO_CATALOG_CONFIG_DIR_DEFAULT_VALUE = "etc/catalog";
    public static final String TRINO_CATALOG_STORE_DEFAULT_VALUE = "file";
    public static final String TRINO_CATALOG_MANAGEMENT_DEFAULT_VALUE = "static";
    public static final TrinoConfig trinoConfig = new TrinoConfig();
    public static final String GRAVITINO_DYNAMIC_CONNECTOR = "__gravitino.dynamic.connector";
    public static final String GRAVITINO_DYNAMIC_CONNECTOR_CATALOG_CONFIG = "__gravitino.dynamic.connector.catalog.config";
    private static final Map<String, ConfigEntry> CONFIG_DEFINITIONS = new HashMap<String, ConfigEntry>();
    private final Map<String, String> config;
    private static final ConfigEntry GRAVITINO_URI = new ConfigEntry("gravitino.uri", "The uri of the gravitino web server", "http://localhost:8090", false);
    private static final ConfigEntry GRAVITINO_METALAKE = new ConfigEntry("gravitino.metalake", "The metalake name for used", "", true);
    @Deprecated
    private static final ConfigEntry GRAVITINO_SIMPLIFY_CATALOG_NAMES = new ConfigEntry("gravitino.simplify-catalog-names", "Omit metalake prefix for catalog names, is deprecated, use gravitino.use-single-metalake instead", "true", false);
    private static final ConfigEntry GRAVITINO_SINGLE_METALAKE_MODE = new ConfigEntry("gravitino.use-single-metalake", "If true, only one metalake is supported in this connector; identify the catalog by <catalog_name>. If false, multiple metalakes are supported; identify the catalog by <metalake_name>.<catalog_name>.", "true", false);
    private static final ConfigEntry GRAVITINO_CLOUD_REGION_CODE = new ConfigEntry("gravitino.cloud.region-code", "The property to specify the region code of the cloud that the catalog is running on.", "", false);
    private static final ConfigEntry GRAVITINO_CATALOG_CONNECTOR_FACTORY_CLASS_NAME = new ConfigEntry("gravitino.catalog.connector.factory.class.name", "The class name for the custom CatalogConnectorFactory. The class must implement the CatalogConnectorFactory interface", "", false);
    private static final ConfigEntry TRINO_JDBC_USER = new ConfigEntry("trino.jdbc.user", "The jdbc user name of Trino", "admin", false);
    private static final ConfigEntry TRINO_JDBC_PASSWORD = new ConfigEntry("trino.jdbc.password", "The jdbc user password of Trino", "", false);
    private static final ConfigEntry GRAVITINO_METADATA_REFRESH_INTERVAL_SECOND = new ConfigEntry("gravitino.metadata.refresh-interval-seconds", "The interval in seconds to refresh the metadata from Gravitino server", "10", false);
    private static final ConfigEntry GRAVITINO_TRINO_SKIP_VERSION_VALIDATION = new ConfigEntry("gravitino.trino.skip-version-validation", "The property to specify whether skip Trino version validation or not. Note there may be compatiablity problem if true.", "false", false);
    private static final ConfigEntry GRAVITINO_CLIENT_CONFIG_PREFIX = new ConfigEntry("gravitino.client.", "The config prefix for Grivitino client", "", false);

    public GravitinoConfig(Map<String, String> requiredConfig) {
        this.config = requiredConfig;
        for (Map.Entry<String, ConfigEntry> entry : CONFIG_DEFINITIONS.entrySet()) {
            ConfigEntry configDefinition = entry.getValue();
            if (!configDefinition.isRequired || this.config.containsKey(configDefinition.key)) continue;
            String message = String.format("Missing gravitino config, %s is required", configDefinition.key);
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_CONFIG, message);
        }
        if (this.isDynamicConnector() && !this.config.containsKey(GRAVITINO_DYNAMIC_CONNECTOR_CATALOG_CONFIG)) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_CONFIG, "Incomplete Dynamic catalog connector config");
        }
    }

    public String getURI() {
        return this.config.getOrDefault(GravitinoConfig.GRAVITINO_URI.key, GravitinoConfig.GRAVITINO_URI.defaultValue);
    }

    public String getMetalake() {
        return this.config.getOrDefault(GravitinoConfig.GRAVITINO_METALAKE.key, GravitinoConfig.GRAVITINO_METALAKE.defaultValue);
    }

    public Map<String, String> getClientConfig() {
        return this.config.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith(GravitinoConfig.GRAVITINO_CLIENT_CONFIG_PREFIX.key)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean singleMetalakeMode() {
        return Boolean.parseBoolean(this.config.getOrDefault(GravitinoConfig.GRAVITINO_SINGLE_METALAKE_MODE.key, GravitinoConfig.GRAVITINO_SINGLE_METALAKE_MODE.defaultValue));
    }

    boolean isDynamicConnector() {
        return this.config.getOrDefault(GRAVITINO_DYNAMIC_CONNECTOR, "false").equals("true");
    }

    public String getCatalogConfig() {
        return this.config.get(GRAVITINO_DYNAMIC_CONNECTOR_CATALOG_CONFIG);
    }

    public String getTrinoJdbcURI() {
        String uriString = "";
        uriString = this.config.containsKey(TRINO_DISCOVERY_URI) ? this.config.get(TRINO_DISCOVERY_URI) : trinoConfig.getProperty(TRINO_DISCOVERY_URI);
        try {
            URI trinoURI = new URI(uriString);
            return String.format("jdbc:trino://%s:%s", trinoURI.getHost(), trinoURI.getPort());
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_CONFIG, "The Trino configuration of `discovery.uri` = " + uriString + " is not correct");
        }
    }

    public String getRegion() {
        return this.config.getOrDefault(GravitinoConfig.GRAVITINO_CLOUD_REGION_CODE.key, GravitinoConfig.GRAVITINO_CLOUD_REGION_CODE.defaultValue);
    }

    public String getCatalogConfigDirectory() {
        if (this.config.containsKey(TRINO_CATALOG_CONFIG_DIR)) {
            return this.config.get(TRINO_CATALOG_CONFIG_DIR);
        }
        return trinoConfig.getProperty(TRINO_CATALOG_CONFIG_DIR, TRINO_CATALOG_CONFIG_DIR_DEFAULT_VALUE);
    }

    public String getTrinoUser() {
        return this.config.getOrDefault(GravitinoConfig.TRINO_JDBC_USER.key, GravitinoConfig.TRINO_JDBC_USER.defaultValue);
    }

    public String getTrinoPassword() {
        return this.config.getOrDefault(GravitinoConfig.TRINO_JDBC_PASSWORD.key, GravitinoConfig.TRINO_JDBC_PASSWORD.defaultValue);
    }

    public String getCatalogConnectorFactoryClassName() {
        return this.config.getOrDefault(GravitinoConfig.GRAVITINO_CATALOG_CONNECTOR_FACTORY_CLASS_NAME.key, GravitinoConfig.GRAVITINO_CATALOG_CONNECTOR_FACTORY_CLASS_NAME.defaultValue);
    }

    public String toCatalogConfig() {
        ArrayList<String> stringList = new ArrayList<String>();
        for (Map.Entry<String, ConfigEntry> entry : CONFIG_DEFINITIONS.entrySet()) {
            String value = this.config.get(entry.getKey());
            if (value == null) continue;
            stringList.add(String.format("\"%s\"='%s'", entry.getKey(), value));
        }
        return StringUtils.join(stringList, (char)',');
    }

    public String getMetadataRefreshIntervalSecond() {
        return this.config.getOrDefault(GravitinoConfig.GRAVITINO_METADATA_REFRESH_INTERVAL_SECOND.key, GravitinoConfig.GRAVITINO_METADATA_REFRESH_INTERVAL_SECOND.defaultValue);
    }

    public Boolean isSkipTrinoVersionValidation() {
        return Boolean.parseBoolean(this.config.getOrDefault(GravitinoConfig.GRAVITINO_TRINO_SKIP_VERSION_VALIDATION.key, GravitinoConfig.GRAVITINO_TRINO_SKIP_VERSION_VALIDATION.defaultValue));
    }

    static class ConfigEntry {
        final String key;
        final String description;
        final String defaultValue;
        final boolean isRequired;

        ConfigEntry(String key, String description, String defaultValue, boolean isRequired) {
            this.key = key;
            this.description = description;
            this.defaultValue = defaultValue;
            this.isRequired = isRequired;
            CONFIG_DEFINITIONS.put(key, this);
        }
    }

    static class TrinoConfig {
        private final Properties properties = new Properties();

        public TrinoConfig() {
            try {
                String configFileName = System.getProperty("config");
                if (StringUtils.isEmpty((CharSequence)configFileName)) {
                    return;
                }
                try (FileInputStream input = new FileInputStream(configFileName);){
                    this.properties.load(input);
                }
                if (this.properties.containsKey(GravitinoConfig.TRINO_CATALOG_STORE) && !this.properties.getProperty(GravitinoConfig.TRINO_CATALOG_STORE).equals(GravitinoConfig.TRINO_CATALOG_STORE_DEFAULT_VALUE)) {
                    throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_CONFIG, "Gravitino connector works only at catalog.store = file mode");
                }
                if (!this.properties.containsKey(GravitinoConfig.TRINO_CATALOG_MANAGEMENT) || GravitinoConfig.TRINO_CATALOG_MANAGEMENT_DEFAULT_VALUE.equals(this.properties.getProperty(GravitinoConfig.TRINO_CATALOG_MANAGEMENT))) {
                    throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_CONFIG, "Gravitino connector works only at catalog.management = dynamic mode");
                }
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_MISSING_CONFIG, "Missing the Trino config file, please verify the jvm args '-Dconfig'");
            }
        }

        String getProperty(String key) {
            return this.properties.getProperty(key);
        }

        String getProperty(String key, String defaultValue) {
            return this.properties.getProperty(key, defaultValue);
        }

        boolean contains(String key) {
            return this.properties.containsKey(key);
        }
    }
}

