/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.stats;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.stats.StatisticDTO;
import org.apache.gravitino.stats.PartitionStatistics;
import org.apache.gravitino.stats.Statistic;

public class PartitionStatisticsDTO
implements PartitionStatistics {
    @JsonProperty(value="partitionName")
    private String partitionName;
    @JsonProperty(value="statistics")
    private StatisticDTO[] statistics;

    protected PartitionStatisticsDTO() {
        this(null, null);
    }

    private PartitionStatisticsDTO(String partitionName, StatisticDTO[] statistics) {
        this.partitionName = partitionName;
        this.statistics = statistics;
    }

    public String partitionName() {
        return this.partitionName;
    }

    public Statistic[] statistics() {
        return this.statistics;
    }

    public void validate() {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)this.partitionName), (Object)"\"partitionName\" must not be null or empty");
        Preconditions.checkArgument((this.statistics != null ? 1 : 0) != 0, (Object)"\"statistics\" must not be null");
        for (StatisticDTO statistic : this.statistics) {
            statistic.validate();
        }
    }

    public static PartitionStatisticsDTO of(String partitionName, StatisticDTO[] statistics) {
        PartitionStatisticsDTO dto = new PartitionStatisticsDTO(partitionName, statistics);
        dto.validate();
        return dto;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PartitionStatisticsDTO)) {
            return false;
        }
        PartitionStatisticsDTO other = (PartitionStatisticsDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$partitionName = this.partitionName;
        String other$partitionName = other.partitionName;
        if (this$partitionName == null ? other$partitionName != null : !this$partitionName.equals(other$partitionName)) {
            return false;
        }
        return Arrays.deepEquals(this.statistics, other.statistics);
    }

    protected boolean canEqual(Object other) {
        return other instanceof PartitionStatisticsDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $partitionName = this.partitionName;
        result = result * 59 + ($partitionName == null ? 43 : $partitionName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.statistics);
        return result;
    }

    public String toString() {
        return "PartitionStatisticsDTO(partitionName=" + this.partitionName + ", statistics=" + Arrays.deepToString(this.statistics) + ")";
    }
}

