/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.tag.MetadataObjectDTO;

public class MetadataObjectListResponse
extends BaseResponse {
    @JsonProperty(value="metadataObjects")
    private final MetadataObjectDTO[] metadataObjects;

    public MetadataObjectListResponse(MetadataObjectDTO[] metadataObjects) {
        super(0);
        this.metadataObjects = metadataObjects;
    }

    public MetadataObjectListResponse() {
        this.metadataObjects = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument((this.metadataObjects != null ? 1 : 0) != 0, (Object)"metadataObjects must be non-null");
        Arrays.stream(this.metadataObjects).forEach(object -> Preconditions.checkArgument((object != null && StringUtils.isNotBlank((CharSequence)object.name()) && object.type() != null ? 1 : 0) != 0, (Object)"metadataObject must not be null and it's field cannot null or empty"));
    }

    public MetadataObjectDTO[] getMetadataObjects() {
        return this.metadataObjects;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataObjectListResponse)) {
            return false;
        }
        MetadataObjectListResponse other = (MetadataObjectListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getMetadataObjects(), other.getMetadataObjects());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MetadataObjectListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getMetadataObjects());
        return result;
    }

    @Override
    public String toString() {
        return "MetadataObjectListResponse(metadataObjects=" + Arrays.deepToString(this.getMetadataObjects()) + ")";
    }
}

