/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.db;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.semconv.SemanticAttributes;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.db.SqlStatementSanitizer;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesExtractor;
import io.trino.jdbc.$internal.opentelemetry.instrumentation.api.instrumenter.db.SqlClientAttributesGetter;
import java.util.Objects;

public final class SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> {
    final SqlClientAttributesGetter<REQUEST> getter;
    AttributeKey<String> dbTableAttribute = SemanticAttributes.DB_SQL_TABLE;
    boolean statementSanitizationEnabled = true;

    SqlClientAttributesExtractorBuilder(SqlClientAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @CanIgnoreReturnValue
    public SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> setTableAttribute(AttributeKey<String> dbTableAttribute) {
        this.dbTableAttribute = Objects.requireNonNull(dbTableAttribute);
        return this;
    }

    @CanIgnoreReturnValue
    public SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> setStatementSanitizationEnabled(boolean statementSanitizationEnabled) {
        this.statementSanitizationEnabled = statementSanitizationEnabled;
        return this;
    }

    public AttributesExtractor<REQUEST, RESPONSE> build() {
        return new SqlClientAttributesExtractor(this.getter, this.dbTableAttribute, SqlStatementSanitizer.create(this.statementSanitizationEnabled));
    }
}

