/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.dev.failsafe;

import io.trino.jdbc.$internal.dev.failsafe.FailsafeExecutor;
import io.trino.jdbc.$internal.dev.failsafe.Policy;
import io.trino.jdbc.$internal.dev.failsafe.internal.util.Assert;
import io.trino.jdbc.$internal.dev.failsafe.internal.util.Lists;
import java.util.Collections;
import java.util.List;

public class Failsafe {
    @SafeVarargs
    public static <R, P extends Policy<R>> FailsafeExecutor<R> with(P outerPolicy, P ... policies) {
        Assert.notNull(outerPolicy, "outerPolicy");
        return new FailsafeExecutor(Lists.of(outerPolicy, policies));
    }

    public static <R> FailsafeExecutor<R> with(List<? extends Policy<R>> policies) {
        Assert.notNull(policies, "policies");
        Assert.isTrue(!policies.isEmpty(), "At least one policy must be supplied", new Object[0]);
        return new FailsafeExecutor(policies);
    }

    public static <R> FailsafeExecutor<R> none() {
        return new FailsafeExecutor(Collections.emptyList());
    }
}

