/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.policy;

import java.util.Optional;
import org.apache.gravitino.Auditable;
import org.apache.gravitino.MetadataObject;
import org.apache.gravitino.annotation.Evolving;
import org.apache.gravitino.policy.PolicyContent;
import org.apache.gravitino.policy.PolicyContents;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;
import org.apache.gravitino.shaded.org.apache.commons.lang3.StringUtils;

@Evolving
public interface Policy
extends Auditable {
    public static final String BUILT_IN_TYPE_PREFIX = "system_";

    public String name();

    public String policyType();

    public String comment();

    public boolean enabled();

    public PolicyContent content();

    public Optional<Boolean> inherited();

    default public AssociatedObjects associatedObjects() {
        throw new UnsupportedOperationException("The associatedObjects method is not supported.");
    }

    public static interface AssociatedObjects {
        default public int count() {
            MetadataObject[] objects = this.objects();
            return objects == null ? 0 : objects.length;
        }

        public MetadataObject[] objects();
    }

    public static enum BuiltInType {
        CUSTOM("custom", PolicyContents.CustomContent.class);

        private final String policyType;
        private final Class<? extends PolicyContent> contentClass;

        private BuiltInType(String policyType, Class<? extends PolicyContent> contentClass) {
            this.policyType = policyType;
            this.contentClass = contentClass;
        }

        public static BuiltInType fromPolicyType(String policyType) {
            Preconditions.checkArgument(StringUtils.isNotBlank(policyType), "policyType cannot be blank");
            for (BuiltInType type : BuiltInType.values()) {
                if (!type.policyType.equalsIgnoreCase(policyType)) continue;
                return type;
            }
            if (policyType.startsWith(Policy.BUILT_IN_TYPE_PREFIX)) {
                throw new IllegalArgumentException(String.format("Unknown built-in policy type: %s", policyType));
            }
            throw new IllegalArgumentException(String.format("Unknown policy type: %s, it should start with '%s' or be 'custom'", policyType, Policy.BUILT_IN_TYPE_PREFIX));
        }

        public String policyType() {
            return this.policyType;
        }

        public Class<? extends PolicyContent> contentClass() {
            return this.contentClass;
        }
    }
}

