/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.responses;

import java.util.Arrays;
import org.apache.gravitino.dto.responses.BaseResponse;
import org.apache.gravitino.dto.tag.TagDTO;
import org.apache.gravitino.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.gravitino.shaded.com.google.common.base.Preconditions;

public class TagListResponse
extends BaseResponse {
    @JsonProperty(value="tags")
    private final TagDTO[] tags;

    public TagListResponse(TagDTO[] tags) {
        super(0);
        this.tags = tags;
    }

    public TagListResponse() {
        this.tags = null;
    }

    @Override
    public void validate() throws IllegalArgumentException {
        super.validate();
        Preconditions.checkArgument(this.tags != null, "\"tags\" must not be null");
        Arrays.stream(this.tags).forEach(t2 -> Preconditions.checkArgument(t2 != null, "tag must not be null"));
    }

    public TagDTO[] getTags() {
        return this.tags;
    }

    @Override
    public String toString() {
        return "TagListResponse(tags=" + Arrays.deepToString(this.getTags()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagListResponse)) {
            return false;
        }
        TagListResponse other = (TagListResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getTags(), other.getTags());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TagListResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getTags());
        return result;
    }
}

