/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.dto.rel.partitioning;

import java.util.Arrays;
import org.apache.gravitino.dto.rel.ColumnDTO;
import org.apache.gravitino.dto.rel.PartitionUtils;
import org.apache.gravitino.dto.rel.expressions.FunctionArg;
import org.apache.gravitino.dto.rel.partitioning.Partitioning;
import org.apache.gravitino.rel.expressions.Expression;

public final class FunctionPartitioningDTO
implements Partitioning {
    String functionName;
    FunctionArg[] args;

    public static FunctionPartitioningDTO of(String functionName, FunctionArg ... args) {
        return new FunctionPartitioningDTO(functionName, args);
    }

    private FunctionPartitioningDTO(String functionName, FunctionArg[] args) {
        this.functionName = functionName;
        this.args = args;
    }

    public String functionName() {
        return this.functionName;
    }

    public FunctionArg[] args() {
        return this.args;
    }

    @Override
    public String name() {
        return this.functionName;
    }

    @Override
    public Expression[] arguments() {
        return this.args;
    }

    @Override
    public Partitioning.Strategy strategy() {
        return Partitioning.Strategy.FUNCTION;
    }

    @Override
    public void validate(ColumnDTO[] columns) throws IllegalArgumentException {
        Arrays.stream(this.references()).forEach(ref -> PartitionUtils.validateFieldExistence(columns, ref.fieldName()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FunctionPartitioningDTO)) {
            return false;
        }
        FunctionPartitioningDTO other = (FunctionPartitioningDTO)o;
        String this$functionName = this.functionName;
        String other$functionName = other.functionName;
        if (this$functionName == null ? other$functionName != null : !this$functionName.equals(other$functionName)) {
            return false;
        }
        return Arrays.deepEquals(this.args, other.args);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $functionName = this.functionName;
        result = result * 59 + ($functionName == null ? 43 : $functionName.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.args);
        return result;
    }
}

