/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.credential;

import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.gravitino.credential.Credential;
import org.apache.gravitino.shaded.com.google.common.collect.Iterables;
import org.apache.gravitino.shaded.com.google.common.collect.Streams;

public class CredentialFactory {
    public static Credential create(String credentialType, Map<String, String> credentialInfo, long expireTimeInMs) {
        Class<? extends Credential> credentialClz = CredentialFactory.lookupCredential(credentialType);
        try {
            Credential credential = credentialClz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            credential.initialize(credentialInfo, expireTimeInMs);
            return credential;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<? extends Credential> lookupCredential(String credentialType) {
        ServiceLoader<Credential> serviceLoader = ServiceLoader.load(Credential.class);
        List credentials = Streams.stream(serviceLoader.iterator()).filter(credential -> credentialType.equalsIgnoreCase(credential.credentialType())).map(Object::getClass).collect(Collectors.toList());
        if (credentials.isEmpty()) {
            throw new RuntimeException("No credential found for: " + credentialType);
        }
        if (credentials.size() > 1) {
            throw new RuntimeException("Multiple credential found for: " + credentialType);
        }
        return (Class)Iterables.getOnlyElement(credentials);
    }
}

