/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.iceberg.service.dispatcher;

import org.apache.gravitino.iceberg.service.IcebergCatalogWrapperManager;
import org.apache.gravitino.iceberg.service.dispatcher.IcebergNamespaceOperationDispatcher;
import org.apache.gravitino.listener.api.event.IcebergRequestContext;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;

public class IcebergNamespaceOperationExecutor
implements IcebergNamespaceOperationDispatcher {
    private IcebergCatalogWrapperManager icebergCatalogWrapperManager;

    public IcebergNamespaceOperationExecutor(IcebergCatalogWrapperManager icebergCatalogWrapperManager) {
        this.icebergCatalogWrapperManager = icebergCatalogWrapperManager;
    }

    @Override
    public CreateNamespaceResponse createNamespace(IcebergRequestContext context, CreateNamespaceRequest createNamespaceRequest) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).createNamespace(createNamespaceRequest);
    }

    @Override
    public UpdateNamespacePropertiesResponse updateNamespace(IcebergRequestContext context, Namespace namespace, UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).updateNamespaceProperties(namespace, updateNamespacePropertiesRequest);
    }

    @Override
    public void dropNamespace(IcebergRequestContext context, Namespace namespace) {
        this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).dropNamespace(namespace);
    }

    @Override
    public GetNamespaceResponse loadNamespace(IcebergRequestContext context, Namespace namespace) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).loadNamespace(namespace);
    }

    @Override
    public ListNamespacesResponse listNamespaces(IcebergRequestContext context, Namespace parentNamespace) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).listNamespace(parentNamespace);
    }

    @Override
    public boolean namespaceExists(IcebergRequestContext context, Namespace namespace) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).namespaceExists(namespace);
    }

    @Override
    public LoadTableResponse registerTable(IcebergRequestContext context, Namespace namespace, RegisterTableRequest registerTableRequest) {
        return this.icebergCatalogWrapperManager.getCatalogWrapper(context.catalogName()).registerTable(namespace, registerTableRequest);
    }
}

