/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import { defHttp } from '@/lib/utils/axios'

const Apis = {
  GET: ({ metalake, catalog }) =>
    `/api/metalakes/${encodeURIComponent(metalake)}/catalogs/${encodeURIComponent(catalog)}/schemas`,
  GET_DETAIL: ({ metalake, catalog, schema }) =>
    `/api/metalakes/${encodeURIComponent(metalake)}/catalogs/${encodeURIComponent(
      catalog
    )}/schemas/${encodeURIComponent(schema)}`,
  CREATE: ({ metalake, catalog }) =>
    `/api/metalakes/${encodeURIComponent(metalake)}/catalogs/${encodeURIComponent(catalog)}/schemas`,
  UPDATE: ({ metalake, catalog, schema }) =>
    `/api/metalakes/${encodeURIComponent(metalake)}/catalogs/${encodeURIComponent(catalog)}/schemas/${encodeURIComponent(schema)}`,
  DELETE: ({ metalake, catalog, schema }) =>
    `/api/metalakes/${encodeURIComponent(metalake)}/catalogs/${encodeURIComponent(catalog)}/schemas/${encodeURIComponent(schema)}`
}

export const getSchemasApi = params => {
  return defHttp.get({
    url: `${Apis.GET(params)}`
  })
}

export const getSchemaDetailsApi = ({ metalake, catalog, schema }) => {
  return defHttp.get({
    url: `${Apis.GET_DETAIL({ metalake, catalog, schema })}`
  })
}

export const createSchemaApi = ({ metalake, catalog, data }) => {
  return defHttp.post({ url: `${Apis.CREATE({ metalake, catalog })}`, data })
}

export const updateSchemaApi = ({ metalake, catalog, schema, data }) => {
  return defHttp.put({ url: `${Apis.UPDATE({ metalake, catalog, schema })}`, data })
}

export const deleteSchemaApi = ({ metalake, catalog, schema }) => {
  return defHttp.delete({ url: `${Apis.DELETE({ metalake, catalog, schema })}` })
}
