/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.lucene.internal.distributed;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.lucene.LuceneQueryProvider;
import org.apache.geode.cache.lucene.internal.distributed.CollectorManager;
import org.apache.geode.cache.lucene.internal.repository.IndexResultCollector;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;

public class LuceneFunctionContext<C extends IndexResultCollector>
implements DataSerializableFixedID {
    private CollectorManager<C> manager;
    private int limit;
    private LuceneQueryProvider queryProvider;
    private String indexName;

    public LuceneFunctionContext() {
        this(null, null, null);
    }

    public LuceneFunctionContext(LuceneQueryProvider provider, String indexName) {
        this(provider, indexName, null);
    }

    public LuceneFunctionContext(LuceneQueryProvider provider, String indexName, CollectorManager<C> manager) {
        this(provider, indexName, manager, 100);
    }

    public LuceneFunctionContext(LuceneQueryProvider provider, String indexName, CollectorManager<C> manager, int limit) {
        this.queryProvider = provider;
        this.indexName = indexName;
        this.manager = manager;
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public CollectorManager<C> getCollectorManager() {
        return this.manager;
    }

    public LuceneQueryProvider getQueryProvider() {
        return this.queryProvider;
    }

    public int getDSFID() {
        return 2171;
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
        out.writeInt(this.limit);
        context.getSerializer().writeObject((Object)this.queryProvider, out);
        context.getSerializer().writeObject(this.manager, out);
        DataSerializer.writeString((String)this.indexName, (DataOutput)out);
    }

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        this.limit = in.readInt();
        this.queryProvider = (LuceneQueryProvider)context.getDeserializer().readObject(in);
        this.manager = (CollectorManager)context.getDeserializer().readObject(in);
        this.indexName = DataSerializer.readString((DataInput)in);
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

