/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.remote.caucho.hessian;

import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import java.io.OutputStream;
import mx4j.tools.remote.caucho.CauchoOutput;
import mx4j.tools.remote.caucho.serialization.JMXSerializerFactory;

class HessianCauchoOutput
implements CauchoOutput {
    private final OutputStream stream;
    private final HessianOutput output;

    HessianCauchoOutput(OutputStream stream) {
        this.stream = stream;
        this.output = new HessianOutput();
        this.output.setSerializerFactory((SerializerFactory)new JMXSerializerFactory());
        this.output.init(stream);
    }

    public void startReply() throws IOException {
        this.output.startReply();
    }

    public void completeReply() throws IOException {
        this.output.completeReply();
    }

    public void startCall() throws IOException {
        this.stream.write(99);
        this.stream.write(0);
        this.stream.write(1);
    }

    public void completeCall() throws IOException {
        this.output.completeCall();
    }

    public void writeHeader(String header) throws IOException {
        this.output.writeHeader(header);
    }

    public void writeMethod(String methodName) throws IOException {
        this.stream.write(109);
        int len = methodName.length();
        this.stream.write(len >> 8);
        this.stream.write(len);
        this.output.printString(methodName, 0, len);
    }

    public void writeObject(Object object) throws IOException {
        this.output.writeObject(object);
    }

    public void writeFault(Throwable fault) throws IOException {
        this.output.writeFault(fault.getClass().getName(), fault.getMessage(), (Object)fault);
    }
}

