/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.unsafe.internal.sun.misc;

import java.util.Objects;
import org.apache.geode.unsafe.internal.sun.misc.SignalHandler;

public class Signal {
    final sun.misc.Signal signal;

    public Signal(String name) {
        this.signal = new sun.misc.Signal(name);
    }

    public int getNumber() {
        return Signal.unwrap(this).getNumber();
    }

    public String getName() {
        return Signal.unwrap(this).getName();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Signal)) {
            return false;
        }
        return Signal.unwrap((Signal)other).equals(Signal.unwrap(this));
    }

    public int hashCode() {
        return Signal.unwrap(this).hashCode();
    }

    public String toString() {
        return Signal.unwrap(this).toString();
    }

    public static synchronized SignalHandler handle(Signal signal, SignalHandler signalHandler) throws IllegalArgumentException {
        Objects.requireNonNull(signal);
        Objects.requireNonNull(signalHandler);
        return Signal.wrap(sun.misc.Signal.handle(Signal.unwrap(signal), Signal.wrap(signalHandler)));
    }

    public static void raise(Signal signal) throws IllegalArgumentException {
        Objects.requireNonNull(signal);
        sun.misc.Signal.raise(Signal.unwrap(signal));
    }

    private static sun.misc.SignalHandler wrap(SignalHandler signalHandler) {
        if (signalHandler instanceof SunSignalHandler) {
            return ((SunSignalHandler)signalHandler).signalHandler;
        }
        return new GeodeSignalHandler(signalHandler);
    }

    private static Signal wrap(sun.misc.Signal signal) {
        return new Signal(signal.getName());
    }

    private static sun.misc.Signal unwrap(Signal signal) {
        return signal.signal;
    }

    private static SignalHandler wrap(sun.misc.SignalHandler signalHandler) {
        if (signalHandler == sun.misc.SignalHandler.SIG_DFL) {
            return SignalHandler.SIG_DFL;
        }
        if (signalHandler == sun.misc.SignalHandler.SIG_IGN) {
            return SignalHandler.SIG_IGN;
        }
        if (signalHandler instanceof GeodeSignalHandler) {
            return ((GeodeSignalHandler)signalHandler).signalHandler;
        }
        return new SunSignalHandler(signalHandler);
    }

    static class SunSignalHandler
    implements SignalHandler {
        final sun.misc.SignalHandler signalHandler;

        SunSignalHandler(sun.misc.SignalHandler signalHandler) {
            this.signalHandler = signalHandler;
        }

        @Override
        public void handle(Signal signal) {
            this.signalHandler.handle(Signal.unwrap(signal));
        }
    }

    private static class GeodeSignalHandler
    implements sun.misc.SignalHandler {
        private final SignalHandler signalHandler;

        GeodeSignalHandler(SignalHandler signalHandler) {
            this.signalHandler = signalHandler;
        }

        @Override
        public void handle(sun.misc.Signal signal) {
            this.signalHandler.handle(Signal.wrap(signal));
        }
    }
}

