/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.connectors.jdbc.internal;

import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.geode.connectors.jdbc.JdbcConnectorException;
import org.apache.geode.pdx.FieldType;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.WritablePdxInstance;

public class SqlToPdxInstance {
    private PdxInstance pdxTemplate;
    private final Map<String, PdxFieldInfo> columnToPdxFieldMap = new HashMap<String, PdxFieldInfo>();

    PdxInstance getPdxTemplate() {
        return this.pdxTemplate;
    }

    public void setPdxTemplate(PdxInstance template) {
        this.pdxTemplate = template;
    }

    public void addMapping(String columnName, String pdxFieldName, FieldType pdxFieldType) {
        this.columnToPdxFieldMap.put(columnName, new PdxFieldInfo(pdxFieldName, pdxFieldType));
    }

    Map<String, PdxFieldInfo> getColumnToPdxFieldMap() {
        return this.columnToPdxFieldMap;
    }

    public PdxInstance create(ResultSet resultSet) throws SQLException {
        if (!resultSet.next()) {
            return null;
        }
        WritablePdxInstance result = this.pdxTemplate.createWriter();
        ResultSetMetaData metaData = resultSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String columnName = metaData.getColumnName(i);
            PdxFieldInfo fieldInfo = this.columnToPdxFieldMap.get(columnName);
            if (fieldInfo == null) {
                throw new JdbcConnectorException("The jdbc-mapping does not contain the column name \"" + columnName + "\". This is probably caused by a column being added to the table after the jdbc-mapping was created.");
            }
            Object fieldValue = this.getFieldValue(resultSet, i, fieldInfo.getType(), metaData);
            result.setField(fieldInfo.getName(), fieldValue);
        }
        if (resultSet.next()) {
            throw new JdbcConnectorException("Multiple rows returned for query: " + resultSet.getStatement());
        }
        return result;
    }

    Object getFieldValue(ResultSet resultSet, int columnIndex, FieldType fieldType, ResultSetMetaData metaData) throws SQLException {
        switch (fieldType) {
            case STRING: {
                return resultSet.getString(columnIndex);
            }
            case CHAR: {
                return this.getCharValue(resultSet, columnIndex);
            }
            case SHORT: {
                return resultSet.getShort(columnIndex);
            }
            case INT: {
                return resultSet.getInt(columnIndex);
            }
            case LONG: {
                return resultSet.getLong(columnIndex);
            }
            case FLOAT: {
                return Float.valueOf(resultSet.getFloat(columnIndex));
            }
            case DOUBLE: {
                return resultSet.getDouble(columnIndex);
            }
            case BYTE: {
                return resultSet.getByte(columnIndex);
            }
            case BOOLEAN: {
                return resultSet.getBoolean(columnIndex);
            }
            case DATE: {
                return this.getDateValue(resultSet, columnIndex, metaData);
            }
            case BYTE_ARRAY: {
                return this.getByteArrayValue(resultSet, columnIndex, metaData);
            }
            case BOOLEAN_ARRAY: {
                return this.convertJdbcObjectToJavaType(boolean[].class, resultSet.getObject(columnIndex));
            }
            case CHAR_ARRAY: {
                return this.convertJdbcObjectToJavaType(char[].class, resultSet.getObject(columnIndex));
            }
            case SHORT_ARRAY: {
                return this.convertJdbcObjectToJavaType(short[].class, resultSet.getObject(columnIndex));
            }
            case INT_ARRAY: {
                return this.convertJdbcObjectToJavaType(int[].class, resultSet.getObject(columnIndex));
            }
            case LONG_ARRAY: {
                return this.convertJdbcObjectToJavaType(long[].class, resultSet.getObject(columnIndex));
            }
            case FLOAT_ARRAY: {
                return this.convertJdbcObjectToJavaType(float[].class, resultSet.getObject(columnIndex));
            }
            case DOUBLE_ARRAY: {
                return this.convertJdbcObjectToJavaType(double[].class, resultSet.getObject(columnIndex));
            }
            case STRING_ARRAY: {
                return this.convertJdbcObjectToJavaType(String[].class, resultSet.getObject(columnIndex));
            }
            case OBJECT_ARRAY: {
                return this.convertJdbcObjectToJavaType(Object[].class, resultSet.getObject(columnIndex));
            }
            case ARRAY_OF_BYTE_ARRAYS: {
                return this.convertJdbcObjectToJavaType(byte[][].class, resultSet.getObject(columnIndex));
            }
            case OBJECT: {
                return this.getObjectValue(resultSet, columnIndex, metaData);
            }
        }
        throw new IllegalStateException("unhandled pdx field type: " + fieldType);
    }

    private Object getObjectValue(ResultSet resultSet, int columnIndex, ResultSetMetaData metaData) throws SQLException {
        Object v;
        if (this.isBlobColumn(columnIndex, metaData)) {
            v = this.getBlobData(resultSet, columnIndex);
        } else {
            v = resultSet.getObject(columnIndex);
            if (v instanceof Date) {
                if (v instanceof java.sql.Date) {
                    java.sql.Date sqlDate = (java.sql.Date)v;
                    v = new Date(sqlDate.getTime());
                } else if (v instanceof Time) {
                    Time sqlTime = (Time)v;
                    v = new Date(sqlTime.getTime());
                } else if (v instanceof Timestamp) {
                    Timestamp sqlTimestamp = (Timestamp)v;
                    v = new Date(sqlTimestamp.getTime());
                }
            }
        }
        return v;
    }

    private Object getByteArrayValue(ResultSet resultSet, int columnIndex, ResultSetMetaData metaData) throws SQLException {
        byte[] byteData = this.isBlobColumn(columnIndex, metaData) ? this.getBlobData(resultSet, columnIndex) : resultSet.getBytes(columnIndex);
        return byteData;
    }

    private Object getCharValue(ResultSet resultSet, int columnIndex) throws SQLException {
        char charValue = '\u0000';
        String columnValue = resultSet.getString(columnIndex);
        if (columnValue != null && columnValue.length() > 0) {
            charValue = columnValue.charAt(0);
        }
        return Character.valueOf(charValue);
    }

    private Date getDateValue(ResultSet resultSet, int columnIndex, ResultSetMetaData metaData) throws SQLException {
        Date sqlDate;
        int columnType = metaData.getColumnType(columnIndex);
        switch (columnType) {
            case 91: {
                sqlDate = resultSet.getDate(columnIndex);
                break;
            }
            case 92: 
            case 2013: {
                sqlDate = resultSet.getTime(columnIndex);
                break;
            }
            default: {
                sqlDate = resultSet.getTimestamp(columnIndex);
            }
        }
        Date pdxDate = null;
        if (sqlDate != null) {
            pdxDate = new Date(sqlDate.getTime());
        }
        return pdxDate;
    }

    private boolean isBlobColumn(int columnIndex, ResultSetMetaData metaData) throws SQLException {
        int columnType = metaData.getColumnType(columnIndex);
        return 2004 == columnType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBlobData(ResultSet resultSet, int columnIndex) throws SQLException {
        Blob blob = resultSet.getBlob(columnIndex);
        if (blob == null) {
            return null;
        }
        try {
            long blobLength = blob.length();
            if (blobLength > Integer.MAX_VALUE) {
                throw new JdbcConnectorException("Blob of length " + blobLength + " is too big to be converted to a byte array.");
            }
            byte[] byArray = blob.getBytes(1L, (int)blobLength);
            return byArray;
        }
        finally {
            blob.free();
        }
    }

    private <T> T convertJdbcObjectToJavaType(Class<T> javaType, Object jdbcObject) {
        try {
            return javaType.cast(jdbcObject);
        }
        catch (ClassCastException classCastException) {
            throw JdbcConnectorException.createException("Could not convert " + jdbcObject.getClass().getTypeName() + " to " + javaType.getTypeName(), classCastException);
        }
    }

    static class PdxFieldInfo {
        private final String name;
        private final FieldType type;

        public PdxFieldInfo(String name, FieldType type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public FieldType getType() {
            return this.type;
        }
    }
}

