/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jcl;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogConfigurationException;
import org.apache.commons.logging.LogFactory;
import org.apache.logging.log4j.jcl.LogAdapter;
import org.apache.logging.log4j.spi.LoggerAdapter;
import org.apache.logging.log4j.util.Strings;

public class LogFactoryImpl
extends LogFactory {
    private final LoggerAdapter<Log> adapter = new LogAdapter();
    private final ConcurrentMap<String, Object> attributes = new ConcurrentHashMap<String, Object>();

    public Log getInstance(String name) throws LogConfigurationException {
        return (Log)this.adapter.getLogger(name);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public String[] getAttributeNames() {
        return this.attributes.keySet().toArray(Strings.EMPTY_ARRAY);
    }

    public Log getInstance(Class clazz) throws LogConfigurationException {
        return this.getInstance(clazz.getName());
    }

    public void release() {
        try {
            this.adapter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public void setAttribute(String name, Object value) {
        if (value != null) {
            this.attributes.put(name, value);
        } else {
            this.removeAttribute(name);
        }
    }
}

