/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.util.TimSorter;
import org.apache.lucene.util.packed.PackedLongValues;

final class Sorter {
    final Sort sort;
    static final Scorer FAKESCORER = new Scorer(null){
        float score;
        int doc = -1;
        int freq = 1;

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public DocIdSetIterator iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int freq() throws IOException {
            return this.freq;
        }

        @Override
        public float score() throws IOException {
            return this.score;
        }
    };

    Sorter(Sort sort) {
        if (sort.needsScores()) {
            throw new IllegalArgumentException("Cannot sort an index with a Sort that refers to the relevance score");
        }
        this.sort = sort;
    }

    static boolean isConsistent(DocMap docMap) {
        int maxDoc = docMap.size();
        for (int i = 0; i < maxDoc; ++i) {
            int newID = docMap.oldToNew(i);
            int oldID = docMap.newToOld(newID);
            assert (newID >= 0 && newID < maxDoc) : "doc IDs must be in [0-" + maxDoc + "[, got " + newID;
            assert (i == oldID) : "mapping is inconsistent: " + i + " --oldToNew--> " + newID + " --newToOld--> " + oldID;
            if (i == oldID && newID >= 0 && newID < maxDoc) continue;
            return false;
        }
        return true;
    }

    static DocMap sort(final int maxDoc, DocComparator comparator) {
        boolean sorted = true;
        for (int i = 1; i < maxDoc; ++i) {
            if (comparator.compare(i - 1, i) <= 0) continue;
            sorted = false;
            break;
        }
        if (sorted) {
            return null;
        }
        int[] docs = new int[maxDoc];
        for (int i = 0; i < maxDoc; ++i) {
            docs[i] = i;
        }
        DocValueSorter sorter = new DocValueSorter(docs, comparator);
        sorter.sort(0, docs.length);
        PackedLongValues.Builder newToOldBuilder = PackedLongValues.monotonicBuilder(0.0f);
        for (int i = 0; i < maxDoc; ++i) {
            newToOldBuilder.add(docs[i]);
        }
        final PackedLongValues newToOld = newToOldBuilder.build();
        for (int i = 0; i < maxDoc; ++i) {
            docs[(int)newToOld.get((int)i)] = i;
        }
        PackedLongValues.Builder oldToNewBuilder = PackedLongValues.monotonicBuilder(0.0f);
        for (int i = 0; i < maxDoc; ++i) {
            oldToNewBuilder.add(docs[i]);
        }
        final PackedLongValues oldToNew = oldToNewBuilder.build();
        return new DocMap(){

            @Override
            public int oldToNew(int docID) {
                return (int)oldToNew.get(docID);
            }

            @Override
            public int newToOld(int docID) {
                return (int)newToOld.get(docID);
            }

            @Override
            public int size() {
                return maxDoc;
            }
        };
    }

    static SortField.Type getSortFieldType(SortField sortField) {
        if (sortField instanceof SortedSetSortField) {
            return SortField.Type.STRING;
        }
        if (sortField instanceof SortedNumericSortField) {
            return ((SortedNumericSortField)sortField).getNumericType();
        }
        return sortField.getType();
    }

    static NumericDocValues getOrWrapNumeric(LeafReader reader, SortField sortField) throws IOException {
        if (sortField instanceof SortedNumericSortField) {
            SortedNumericSortField sf = (SortedNumericSortField)sortField;
            return SortedNumericSelector.wrap(DocValues.getSortedNumeric(reader, sf.getField()), sf.getSelector(), sf.getNumericType());
        }
        return DocValues.getNumeric(reader, sortField.getField());
    }

    static SortedDocValues getOrWrapSorted(LeafReader reader, SortField sortField) throws IOException {
        if (sortField instanceof SortedSetSortField) {
            SortedSetSortField sf = (SortedSetSortField)sortField;
            return SortedSetSelector.wrap(DocValues.getSortedSet(reader, sf.getField()), sf.getSelector());
        }
        return DocValues.getSorted(reader, sortField.getField());
    }

    DocMap sort(LeafReader reader) throws IOException {
        SortField[] fields = this.sort.getSort();
        final int[] reverseMul = new int[fields.length];
        final LeafFieldComparator[] comparators = new LeafFieldComparator[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            reverseMul[i] = fields[i].getReverse() ? -1 : 1;
            comparators[i] = fields[i].getComparator(1, i).getLeafComparator(reader.getContext());
            comparators[i].setScorer(FAKESCORER);
        }
        DocComparator comparator = new DocComparator(){

            @Override
            public int compare(int docID1, int docID2) {
                try {
                    for (int i = 0; i < comparators.length; ++i) {
                        comparators[i].copy(0, docID1);
                        comparators[i].setBottom(0);
                        int comp = reverseMul[i] * comparators[i].compareBottom(docID2);
                        if (comp == 0) continue;
                        return comp;
                    }
                    return Integer.compare(docID1, docID2);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        return Sorter.sort(reader.maxDoc(), comparator);
    }

    public String getID() {
        return this.sort.toString();
    }

    public String toString() {
        return this.getID();
    }

    private static final class DocValueSorter
    extends TimSorter {
        private final int[] docs;
        private final DocComparator comparator;
        private final int[] tmp;

        DocValueSorter(int[] docs, DocComparator comparator) {
            super(docs.length / 64);
            this.docs = docs;
            this.comparator = comparator;
            this.tmp = new int[docs.length / 64];
        }

        @Override
        protected int compare(int i, int j) {
            return this.comparator.compare(this.docs[i], this.docs[j]);
        }

        @Override
        protected void swap(int i, int j) {
            int tmpDoc = this.docs[i];
            this.docs[i] = this.docs[j];
            this.docs[j] = tmpDoc;
        }

        @Override
        protected void copy(int src, int dest) {
            this.docs[dest] = this.docs[src];
        }

        @Override
        protected void save(int i, int len) {
            System.arraycopy(this.docs, i, this.tmp, 0, len);
        }

        @Override
        protected void restore(int i, int j) {
            this.docs[j] = this.tmp[i];
        }

        @Override
        protected int compareSaved(int i, int j) {
            return this.comparator.compare(this.tmp[i], this.docs[j]);
        }
    }

    static abstract class DocComparator {
        DocComparator() {
        }

        public abstract int compare(int var1, int var2);
    }

    static abstract class DocMap {
        DocMap() {
        }

        abstract int oldToNew(int var1);

        abstract int newToOld(int var1);

        abstract int size();
    }
}

