/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import java.io.IOException;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesRangeQuery;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;

public class SortedSetDocValuesField
extends Field {
    public static final FieldType TYPE = new FieldType();

    public SortedSetDocValuesField(String name, BytesRef bytes) {
        super(name, TYPE);
        this.fieldsData = bytes;
    }

    public static Query newRangeQuery(String field, BytesRef lowerValue, BytesRef upperValue, boolean lowerInclusive, boolean upperInclusive) {
        return new SortedSetDocValuesRangeQuery(field, lowerValue, upperValue, lowerInclusive, upperInclusive){

            @Override
            SortedSetDocValues getValues(LeafReader reader, String field) throws IOException {
                return DocValues.getSortedSet(reader, field);
            }
        };
    }

    public static Query newExactQuery(String field, BytesRef value) {
        return SortedSetDocValuesField.newRangeQuery(field, value, value, true, true);
    }

    static {
        TYPE.setDocValuesType(DocValuesType.SORTED_SET);
        TYPE.freeze();
    }
}

