/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.table;

import org.springframework.shell.table.CellMatcher;
import org.springframework.shell.table.TableModel;

public class CellMatchers {
    public static CellMatcher table() {
        return new CellMatcher(){

            @Override
            public boolean matches(int row, int column, TableModel model) {
                return true;
            }
        };
    }

    public static CellMatcher column(final int col) {
        return new CellMatcher(){

            @Override
            public boolean matches(int row, int column, TableModel model) {
                return col == column;
            }
        };
    }

    public static CellMatcher row(final int theRow) {
        return new CellMatcher(){

            @Override
            public boolean matches(int row, int column, TableModel model) {
                return theRow == row;
            }
        };
    }

    public static CellMatcher ofType(final Class<?> clazz) {
        return new CellMatcher(){

            @Override
            public boolean matches(int row, int column, TableModel model) {
                Object value = model.getValue(row, column);
                if (value == null) {
                    return false;
                }
                return clazz.isAssignableFrom(value.getClass());
            }
        };
    }
}

