/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support.table;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.springframework.shell.support.table.TableHeader;
import org.springframework.shell.support.table.TableRenderer;
import org.springframework.shell.support.table.TableRow;

public class Table {
    private final Map<Integer, TableHeader> headers = new TreeMap<Integer, TableHeader>();
    private volatile List<TableRow> rows = new ArrayList<TableRow>(0);

    public List<TableRow> getRows() {
        return this.rows;
    }

    public Map<Integer, TableHeader> getHeaders() {
        return this.headers;
    }

    public Table addHeader(Integer columnIndex, TableHeader tableHeader) {
        this.headers.put(columnIndex, tableHeader);
        return this;
    }

    public TableRow newRow() {
        TableRow row = new TableRow();
        this.rows.add(row);
        return row;
    }

    public Table addRow(String ... values) {
        TableRow row = new TableRow();
        int column = 1;
        for (String value : values) {
            row.addValue(column, value);
            ++column;
        }
        this.rows.add(row);
        return this;
    }

    public void calculateColumnWidths() {
        for (Map.Entry<Integer, TableHeader> headerEntry : this.headers.entrySet()) {
            Integer headerEntryKey = headerEntry.getKey();
            for (TableRow tableRow : this.rows) {
                headerEntry.getValue().updateWidth(tableRow.getValue(headerEntryKey).length());
            }
        }
    }

    public String toString() {
        return TableRenderer.renderTextTable(this);
    }

    public int hashCode() {
        this.calculateColumnWidths();
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.rows == null ? 0 : this.rows.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Table other = (Table)obj;
        this.calculateColumnWidths();
        other.calculateColumnWidths();
        if (this.headers == null ? other.headers != null : !this.headers.equals(other.headers)) {
            return false;
        }
        return !(this.rows == null ? other.rows != null : !this.rows.equals(other.rows));
    }
}

