/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.operation;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.internal.operation.OperationState;
import org.apache.geode.management.internal.operation.OperationStateStore;
import org.apache.geode.management.runtime.OperationResult;

public class RegionOperationStateStore
implements OperationStateStore {
    private final Supplier<String> uniqueIdSupplier;
    private final Region<String, OperationState<ClusterManagementOperation<OperationResult>, OperationResult>> region;
    public static final String OPERATION_STATE_REGION_NAME = "__OperationStateRegion";

    @VisibleForTesting
    RegionOperationStateStore(Supplier<String> uniqueIdSupplier, Region<String, OperationState<ClusterManagementOperation<OperationResult>, OperationResult>> region) {
        this.uniqueIdSupplier = uniqueIdSupplier;
        this.region = region;
    }

    public RegionOperationStateStore(InternalCache cache) {
        this(() -> UUID.randomUUID().toString(), RegionOperationStateStore.getRegion(cache));
    }

    private static Region<String, OperationState<ClusterManagementOperation<OperationResult>, OperationResult>> getRegion(InternalCache cache) {
        Region<String, OperationState<ClusterManagementOperation<OperationResult>, OperationResult>> region = cache.getRegion(OPERATION_STATE_REGION_NAME);
        if (region != null) {
            return region;
        }
        InternalRegionFactory regionFactory = cache.createInternalRegionFactory(RegionShortcut.REPLICATE);
        regionFactory.setIsUsedForMetaRegion(true);
        regionFactory.setMetaRegionWithTransactions(false);
        return regionFactory.create(OPERATION_STATE_REGION_NAME);
    }

    @Override
    public <A extends ClusterManagementOperation<?>> String recordStart(A operation, String locator) {
        String opId = this.uniqueIdSupplier.get();
        OperationState operationInstance = new OperationState(opId, operation, new Date());
        operationInstance.setLocator(locator);
        this.region.put(opId, operationInstance);
        return opId;
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> OperationState<A, V> get(String opId) {
        OperationState<ClusterManagementOperation<OperationResult>, OperationResult> result = this.region.get(opId);
        if (result != null) {
            result = result.createCopy();
        }
        return result;
    }

    @VisibleForTesting
    Region<String, OperationState<ClusterManagementOperation<OperationResult>, OperationResult>> getRegion() {
        return this.region;
    }

    @Override
    public <A extends ClusterManagementOperation<V>, V extends OperationResult> List<OperationState<A, V>> list() {
        ArrayList<OperationState<A, V>> result = new ArrayList<OperationState<A, V>>();
        for (OperationState<ClusterManagementOperation<OperationResult>, OperationResult> operationState : this.region.values()) {
            result.add(operationState.createCopy());
        }
        return result;
    }

    @Override
    public <V extends OperationResult> void recordEnd(String opId, V result, Throwable exception) {
        OperationState<ClusterManagementOperation<OperationResult>, OperationResult> operationState = this.region.get(opId);
        operationState.setOperationEnd(new Date(), result, exception);
        this.region.put(opId, operationState);
    }

    @Override
    public void remove(String opId) {
        this.region.remove(opId);
    }
}

