/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.deployment;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ScanResult;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionAdapter;

public class FunctionScanner {
    public Collection<String> findFunctionsInJar(File jarFile) throws IOException {
        ClassGraph fastClasspathScanner = new ClassGraph().disableDirScanning().removeTemporaryFilesAfterScan().overrideClasspath(jarFile.getAbsolutePath());
        try (ScanResult scanResult = fastClasspathScanner.enableClassInfo().scan(1);){
            HashSet<String> functionClasses = new HashSet<String>();
            functionClasses.addAll(scanResult.getClassesImplementing(Function.class.getName()).getNames());
            functionClasses.addAll(scanResult.getSubclasses(FunctionAdapter.class.getName()).getNames());
            HashSet<String> hashSet = functionClasses;
            return hashSet;
        }
    }
}

