/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import org.apache.geode.internal.cache.DiskDirectoryStats;
import org.apache.geode.internal.cache.DiskRegionStats;
import org.apache.geode.management.internal.beans.stats.AggregateRegionStatsMonitor;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;
import org.apache.geode.management.internal.beans.stats.StatType;
import org.apache.geode.management.internal.beans.stats.StatsAverageLatency;
import org.apache.geode.management.internal.beans.stats.StatsRate;

public class DiskRegionBridge {
    private final DiskRegionStats diskRegionStats;
    private final AggregateRegionStatsMonitor aggregateRegionMonitor;
    private final MBeanStatsMonitor diskRegionMonitor;
    private StatsAverageLatency diskRegionReadsAverageLatency;
    private StatsAverageLatency diskRegionWritesAverageLatency;
    private StatsRate diskRegionReadsRate;
    private StatsRate diskRegionWritesRate;
    public static final String DISK_REGION_MONITOR = "DiskRegionMonitor";
    private static final String REGION_MONITOR = "MemberLevelRegionMonitor";

    public DiskRegionBridge(DiskRegionStats stats) {
        this.diskRegionStats = stats;
        this.aggregateRegionMonitor = new AggregateRegionStatsMonitor(REGION_MONITOR);
        this.diskRegionMonitor = new MBeanStatsMonitor(DISK_REGION_MONITOR);
        this.addDiskRegionStats(this.diskRegionStats);
        this.configureDiskRegionMetrics();
    }

    private Number getDiskRegionStatistic(String statName) {
        if (this.diskRegionStats != null) {
            return this.diskRegionStats.getStats().get(statName);
        }
        return 0;
    }

    public void stopMonitor() {
        this.diskRegionMonitor.stopListener();
        this.aggregateRegionMonitor.stopListener();
    }

    public void addDirectoryStats(DiskDirectoryStats diskDirStats) {
        this.aggregateRegionMonitor.addStatisticsToMonitor(diskDirStats.getStats());
    }

    public void addDiskRegionStats(DiskRegionStats diskRegionStats) {
        this.diskRegionMonitor.addStatisticsToMonitor(diskRegionStats.getStats());
    }

    private void configureDiskRegionMetrics() {
        this.diskRegionReadsRate = new StatsRate("reads", StatType.LONG_TYPE, this.diskRegionMonitor);
        this.diskRegionWritesRate = new StatsRate("writes", StatType.LONG_TYPE, this.diskRegionMonitor);
        this.diskRegionReadsAverageLatency = new StatsAverageLatency("reads", StatType.LONG_TYPE, "readTime", this.diskRegionMonitor);
        this.diskRegionWritesAverageLatency = new StatsAverageLatency("writes", StatType.LONG_TYPE, "writeTime", this.diskRegionMonitor);
    }

    public float getDiskReadsRate() {
        return this.diskRegionReadsRate.getRate();
    }

    public float getDiskWritesRate() {
        return this.diskRegionWritesRate.getRate();
    }

    public long getDiskReadsAverageLatency() {
        return this.diskRegionReadsAverageLatency.getAverageLatency();
    }

    public long getDiskWritesAverageLatency() {
        return this.diskRegionWritesAverageLatency.getAverageLatency();
    }

    public long getTotalDiskWritesProgress() {
        return this.getDiskRegionStatistic("writesInProgress").longValue();
    }

    public long getTotalDiskEntriesInVM() {
        return this.getDiskRegionStatistic("entriesInVM").longValue();
    }

    public long getTotalEntriesOnlyOnDisk() {
        return this.getDiskRegionStatistic("entriesOnlyOnDisk").longValue();
    }

    public long getDiskUsage() {
        long diskSpaceUsage = this.aggregateRegionMonitor.getDiskSpace();
        return diskSpaceUsage;
    }

    public long getDiskTaskWaiting() {
        return -1L;
    }
}

