/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Properties;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketFactory;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.internal.serialization.DataSerializableFixedID;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.management.internal.JmxManagerLocatorResponse;

public class JmxManagerLocatorRequest
implements DataSerializableFixedID {
    @Immutable
    private static final JmxManagerLocatorRequest SINGLETON = new JmxManagerLocatorRequest();

    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
    }

    public void toData(DataOutput out, SerializationContext context) throws IOException {
    }

    public int getDSFID() {
        return 2150;
    }

    public String toString() {
        return "JmxManagerLocatorRequest";
    }

    public static JmxManagerLocatorResponse send(String locatorHost, int locatorPort, int msTimeout, Properties sslConfigProps) throws IOException, ClassNotFoundException {
        SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent(sslConfigProps, SecurableCommunicationChannel.LOCATOR);
        SocketCreator socketCreator = new SocketCreator(sslConfig);
        TcpClient client = new TcpClient((TcpSocketCreator)socketCreator, InternalDataSerializer.getDSFIDSerializer().getObjectSerializer(), InternalDataSerializer.getDSFIDSerializer().getObjectDeserializer(), TcpSocketFactory.DEFAULT);
        Object responseFromServer = client.requestToServer(new HostAndPort(locatorHost, locatorPort), (Object)SINGLETON, msTimeout, true);
        if (responseFromServer instanceof JmxManagerLocatorResponse) {
            return (JmxManagerLocatorResponse)responseFromServer;
        }
        throw new IllegalStateException("Unrecognisable response received: This could be the result of trying to connect a non-SSL-enabled client to an SSL-enabled locator.");
    }

    public KnownVersion[] getSerializationVersions() {
        return null;
    }
}

