/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.util.CollectingServiceLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ListCollectingServiceLoader<S>
implements CollectingServiceLoader<S> {
    private static final Logger logger = LogManager.getLogger();
    private final ServiceLoaderWrapper<S> serviceLoaderWrapper;

    public ListCollectingServiceLoader() {
        this(new DefaultServiceLoader());
    }

    @VisibleForTesting
    ListCollectingServiceLoader(ServiceLoaderWrapper<S> serviceLoaderWrapper) {
        this.serviceLoaderWrapper = serviceLoaderWrapper;
    }

    @Override
    public Collection<S> loadServices(Class<S> service) {
        this.serviceLoaderWrapper.load(service);
        ArrayList<S> services = new ArrayList<S>();
        Iterator<S> iterator = this.serviceLoaderWrapper.iterator();
        while (iterator.hasNext()) {
            try {
                S instance = iterator.next();
                services.add(instance);
            }
            catch (ServiceConfigurationError serviceConfigurationError) {
                logger.error("Error while loading implementations of {}", (Object)service.getName(), (Object)serviceConfigurationError);
            }
        }
        return services;
    }

    private static class DefaultServiceLoader<S>
    implements ServiceLoaderWrapper<S> {
        private ServiceLoader<S> actualServiceLoader;

        private DefaultServiceLoader() {
        }

        @Override
        public void load(Class<S> service) {
            this.actualServiceLoader = ServiceLoader.load(service);
        }

        @Override
        public Iterator<S> iterator() throws ServiceConfigurationError {
            return this.actualServiceLoader.iterator();
        }
    }

    static interface ServiceLoaderWrapper<S> {
        public void load(Class<S> var1);

        public Iterator<S> iterator() throws ServiceConfigurationError;
    }
}

