/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.statistics;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.geode.GemFireIOException;
import org.apache.geode.internal.ExitCode;
import org.apache.geode.internal.statistics.StatArchiveFormat;
import org.apache.geode.internal.statistics.StatArchiveWriter;

public class ArchiveSplitter
implements StatArchiveFormat {
    private final File archiveName;
    private final InputStream is;
    private final MyFilterInputStream myIs;
    private final DataInputStream dataIn;
    private DataOutputStream dataOut;
    private OutputStream output;
    private static final int BUFFER_SIZE = 0x100000;
    private final long splitDuration;
    private byte[][] resourceTypes = new byte[256][];
    private byte[][] resourceInstanceTypeCodes = new byte[256][];
    private byte[][] resourceInstanceTokens = new byte[256][];
    private long[][] resourceInstanceBits = new long[256][];
    private static final long DEFAULT_SPLIT_DURATION = 86400000L;
    private long currentDuration = 0L;
    private int splitCount = 0;
    private byte[][] globalTokens = new byte[256][];
    private int globalTokenCount = 0;
    private byte archiveVersion;
    private long startTimeStamp;
    private long systemId;
    private long systemStartTimeStamp;
    private int timeZoneOffset;
    private String timeZoneName;
    private String systemDirectory;
    private String productVersion;
    private String os;
    private String machine;

    public ArchiveSplitter(File archiveName) throws IOException {
        this(archiveName, 86400000L);
    }

    public ArchiveSplitter(File archiveName, long splitDuration) throws IOException {
        this.archiveName = archiveName;
        this.splitDuration = splitDuration;
        this.is = new FileInputStream(archiveName);
        boolean compressed = archiveName.getPath().endsWith(".gz");
        this.myIs = compressed ? new MyFilterInputStream(new BufferedInputStream(new GZIPInputStream(this.is, 0x100000), 0x100000)) : new MyFilterInputStream(new BufferedInputStream(this.is, 0x100000));
        this.dataIn = new DataInputStream(this.myIs);
    }

    private void readHeaderToken() throws IOException {
        byte archiveVersion = this.dataIn.readByte();
        if (archiveVersion <= 1) {
            throw new GemFireIOException(String.format("Archive version: %s is no longer supported.", archiveVersion), null);
        }
        if (archiveVersion > 4) {
            throw new GemFireIOException(String.format("Unsupported archive version: %s .  The supported version is: %s .", archiveVersion, (byte)4), null);
        }
        this.archiveVersion = archiveVersion;
        this.startTimeStamp = this.dataIn.readLong();
        this.systemId = this.dataIn.readLong();
        this.systemStartTimeStamp = this.dataIn.readLong();
        this.timeZoneOffset = this.dataIn.readInt();
        this.timeZoneName = this.dataIn.readUTF();
        this.systemDirectory = this.dataIn.readUTF();
        this.productVersion = this.dataIn.readUTF();
        this.os = this.dataIn.readUTF();
        this.machine = this.dataIn.readUTF();
    }

    private void skipBytes(int count) throws IOException {
        int skipped = this.dataIn.skipBytes(count);
        while (skipped != count) {
            skipped = this.dataIn.skipBytes(count -= skipped);
        }
    }

    private void skipBoolean() throws IOException {
        this.skipBytes(1);
    }

    private void skipLong() throws IOException {
        this.skipBytes(8);
    }

    private void skipUTF() throws IOException {
        this.skipBytes(this.dataIn.readUnsignedShort());
    }

    private void addGlobalToken(byte[] token) {
        if (this.globalTokenCount >= this.globalTokens.length) {
            byte[][] tmp = new byte[this.globalTokenCount + 128][];
            System.arraycopy(this.globalTokens, 0, tmp, 0, this.globalTokens.length);
            this.globalTokens = tmp;
        }
        this.globalTokens[this.globalTokenCount] = token;
        ++this.globalTokenCount;
    }

    private void readResourceTypeToken() throws IOException {
        int resourceTypeId = this.dataIn.readInt();
        this.skipUTF();
        this.skipUTF();
        int statCount = this.dataIn.readUnsignedShort();
        byte[] typeCodes = new byte[statCount];
        for (int i = 0; i < statCount; ++i) {
            this.skipUTF();
            typeCodes[i] = this.dataIn.readByte();
            this.skipBoolean();
            if (this.archiveVersion >= 4) {
                this.skipBoolean();
            }
            this.skipUTF();
            this.skipUTF();
        }
        if (resourceTypeId >= this.resourceTypes.length) {
            byte[][] tmp = new byte[resourceTypeId + 128][];
            System.arraycopy(this.resourceTypes, 0, tmp, 0, this.resourceTypes.length);
            this.resourceTypes = tmp;
        }
        this.resourceTypes[resourceTypeId] = typeCodes;
        this.addGlobalToken(this.myIs.getBytes());
    }

    private void readResourceInstanceCreateToken(boolean initialize) throws IOException {
        int resourceInstId = this.dataIn.readInt();
        this.skipUTF();
        this.skipLong();
        int resourceTypeId = this.dataIn.readInt();
        if (resourceInstId >= this.resourceInstanceBits.length) {
            long[][] tmpBits = new long[resourceInstId + 128][];
            System.arraycopy(this.resourceInstanceBits, 0, tmpBits, 0, this.resourceInstanceBits.length);
            this.resourceInstanceBits = tmpBits;
            byte[][] tmpTypeCodes = new byte[resourceInstId + 128][];
            System.arraycopy(this.resourceInstanceTypeCodes, 0, tmpTypeCodes, 0, this.resourceInstanceTypeCodes.length);
            this.resourceInstanceTypeCodes = tmpTypeCodes;
            byte[][] tmpTokens = new byte[resourceInstId + 128][];
            System.arraycopy(this.resourceInstanceTokens, 0, tmpTokens, 0, this.resourceInstanceTokens.length);
            this.resourceInstanceTokens = tmpTokens;
        }
        byte[] instTypeCodes = this.resourceTypes[resourceTypeId];
        this.resourceInstanceTypeCodes[resourceInstId] = instTypeCodes;
        this.resourceInstanceTokens[resourceInstId] = this.myIs.getBytes();
        this.resourceInstanceTokens[resourceInstId][0] = 4;
        long[] instBits = new long[instTypeCodes.length];
        this.resourceInstanceBits[resourceInstId] = instBits;
        if (initialize) {
            block6: for (int i = 0; i < instBits.length; ++i) {
                switch (instTypeCodes[i]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        instBits[i] = this.dataIn.readByte();
                        continue block6;
                    }
                    case 12: {
                        instBits[i] = this.dataIn.readUnsignedShort();
                        continue block6;
                    }
                    case 4: {
                        instBits[i] = this.dataIn.readShort();
                        continue block6;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        instBits[i] = this.readCompactValue();
                        continue block6;
                    }
                    default: {
                        throw new IOException(String.format("unexpected typeCode value %s", instTypeCodes[i]));
                    }
                }
            }
        }
    }

    private void readResourceInstanceDeleteToken() throws IOException {
        int id = this.dataIn.readInt();
        this.resourceInstanceTypeCodes[id] = null;
        this.resourceInstanceBits[id] = null;
        this.resourceInstanceTokens[id] = null;
    }

    private int readResourceInstId() throws IOException {
        int token = this.dataIn.readUnsignedByte();
        if (token <= 252) {
            return token;
        }
        if (token == 255) {
            return -1;
        }
        if (token == 253) {
            return this.dataIn.readUnsignedShort();
        }
        return this.dataIn.readInt();
    }

    private void readTimeDelta() throws IOException {
        int millisSinceLastSample = this.dataIn.readUnsignedShort();
        if (millisSinceLastSample == 65535) {
            millisSinceLastSample = this.dataIn.readInt();
        }
        this.currentDuration += (long)millisSinceLastSample;
        this.startTimeStamp += (long)millisSinceLastSample;
    }

    private long readCompactValue() throws IOException {
        long v = this.dataIn.readByte();
        if (v < -121L) {
            if (v == -128L) {
                v = this.dataIn.readShort();
            } else {
                int bytesToRead = (byte)v - -128 + 2;
                v = this.dataIn.readByte();
                --bytesToRead;
                while (bytesToRead > 0) {
                    v <<= 8;
                    v |= (long)this.dataIn.readUnsignedByte();
                    --bytesToRead;
                }
            }
        }
        return v;
    }

    private void readSampleToken() throws IOException {
        this.readTimeDelta();
        int resourceInstId = this.readResourceInstId();
        while (resourceInstId != -1) {
            byte[] typeCodes = this.resourceInstanceTypeCodes[resourceInstId];
            long[] bits = this.resourceInstanceBits[resourceInstId];
            int statOffset = this.dataIn.readUnsignedByte();
            while (statOffset != 255) {
                long statDeltaBits;
                switch (typeCodes[statOffset]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        statDeltaBits = this.dataIn.readByte();
                        break;
                    }
                    case 12: {
                        statDeltaBits = this.dataIn.readUnsignedShort();
                        break;
                    }
                    case 4: {
                        statDeltaBits = this.dataIn.readShort();
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        statDeltaBits = this.readCompactValue();
                        break;
                    }
                    default: {
                        throw new IOException(String.format("unexpected typeCode value %s", typeCodes[statOffset]));
                    }
                }
                int n = statOffset;
                bits[n] = bits[n] + statDeltaBits;
                statOffset = this.dataIn.readUnsignedByte();
            }
            resourceInstId = this.readResourceInstId();
        }
    }

    private boolean readToken() throws IOException {
        try {
            byte token = this.dataIn.readByte();
            switch (token) {
                case 77: {
                    this.readHeaderToken();
                    this.myIs.putBytes(this.dataOut);
                    break;
                }
                case 1: {
                    this.readResourceTypeToken();
                    this.myIs.putBytes(this.dataOut);
                    break;
                }
                case 2: 
                case 4: {
                    this.readResourceInstanceCreateToken(token == 4);
                    this.myIs.putBytes(this.dataOut);
                    break;
                }
                case 3: {
                    this.readResourceInstanceDeleteToken();
                    this.myIs.putBytes(this.dataOut);
                    break;
                }
                case 0: {
                    this.readSampleToken();
                    this.myIs.putBytes(this.dataOut);
                    break;
                }
                default: {
                    throw new IOException(String.format("Unexpected token byte value: %s", token));
                }
            }
            return true;
        }
        catch (EOFException ignore) {
            return false;
        }
    }

    private File getOutputName() {
        String inName = this.archiveName.getPath();
        StringBuilder buf = new StringBuilder(inName.length() + 4);
        int idx = inName.lastIndexOf(46);
        if (idx == -1) {
            buf.append(inName);
        } else {
            buf.append(inName, 0, idx);
        }
        buf.append('-').append(this.splitCount);
        if (idx != -1) {
            buf.append(inName.substring(idx));
        }
        return new File(buf.toString());
    }

    private void startSplit() throws IOException {
        int i;
        this.currentDuration = 0L;
        ++this.splitCount;
        this.output = this.archiveName.getPath().endsWith(".gz") ? new GZIPOutputStream((OutputStream)new FileOutputStream(this.getOutputName()), 0x100000) : new BufferedOutputStream(new FileOutputStream(this.getOutputName()), 0x100000);
        this.dataOut = new DataOutputStream(this.output);
        if (this.splitCount > 1) {
            this.dataOut.writeByte(77);
            this.dataOut.writeByte(4);
            this.dataOut.writeLong(this.startTimeStamp);
            this.dataOut.writeLong(this.systemId);
            this.dataOut.writeLong(this.systemStartTimeStamp);
            this.dataOut.writeInt(this.timeZoneOffset);
            this.dataOut.writeUTF(this.timeZoneName);
            this.dataOut.writeUTF(this.systemDirectory);
            this.dataOut.writeUTF(this.productVersion);
            this.dataOut.writeUTF(this.os);
            this.dataOut.writeUTF(this.machine);
        }
        for (i = 0; i < this.globalTokenCount; ++i) {
            this.dataOut.write(this.globalTokens[i]);
        }
        for (i = 0; i < this.resourceInstanceTokens.length; ++i) {
            if (this.resourceInstanceTokens[i] == null) continue;
            this.dataOut.write(this.resourceInstanceTokens[i]);
            byte[] instTypeCodes = this.resourceInstanceTypeCodes[i];
            long[] instBits = this.resourceInstanceBits[i];
            for (int j = 0; j < instBits.length; ++j) {
                StatArchiveWriter.writeStatValue(instTypeCodes[j], instBits[j], (DataOutput)this.dataOut);
            }
        }
    }

    private void endSplit() {
        try {
            this.dataOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.output.close();
        }
        catch (IOException ex) {
            System.err.println("[warning] could not close " + this.getOutputName());
        }
    }

    public void split() throws IOException {
        boolean done = false;
        do {
            done = true;
            this.startSplit();
            while (this.readToken()) {
                if (this.currentDuration < this.splitDuration) continue;
                done = false;
                break;
            }
            this.endSplit();
        } while (!done);
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("Usage: org.apache.geode.internal.statistics.ArchiveSplitter <archive.gfs>");
            ExitCode.FATAL.doSystemExit();
        }
        ArchiveSplitter as = new ArchiveSplitter(new File(args[0]));
        as.split();
    }

    private static class MyFilterInputStream
    extends FilterInputStream {
        private byte[] readBytes = new byte[32000];
        private int idx = 0;

        public MyFilterInputStream(InputStream in) {
            super(in);
        }

        public byte[] getBytes() {
            byte[] result = new byte[this.idx];
            System.arraycopy(this.readBytes, 0, result, 0, result.length);
            return result;
        }

        public void putBytes(DataOutputStream dataOut) throws IOException {
            dataOut.write(this.readBytes, 0, this.idx);
            this.idx = 0;
        }

        @Override
        public void close() throws IOException {
            this.readBytes = null;
            super.close();
        }

        @Override
        public synchronized void reset() throws IOException {
            this.idx = 0;
            super.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            this.makeRoom((int)n);
            int result = super.read(this.readBytes, this.idx, (int)n);
            if (result == -1) {
                return 0L;
            }
            this.idx += result;
            return result;
        }

        private void makeRoom(int n) {
            if (this.idx + n > this.readBytes.length) {
                byte[] tmp = new byte[this.readBytes.length + n + 1024];
                System.arraycopy(this.readBytes, 0, tmp, 0, this.readBytes.length);
                this.readBytes = tmp;
            }
        }

        @Override
        public int read() throws IOException {
            int result = super.read();
            if (result != -1) {
                this.makeRoom(1);
                this.readBytes[this.idx] = (byte)result;
                ++this.idx;
            }
            return result;
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = super.read(b, off, len);
            if (result != -1) {
                this.makeRoom(result);
                System.arraycopy(b, off, this.readBytes, this.idx, result);
                this.idx += result;
            }
            return result;
        }
    }
}

