/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import org.apache.geode.internal.offheap.AddressableMemoryManager;
import org.apache.geode.internal.offheap.Slab;

public class SlabImpl
implements Slab {
    private final long address;
    private final int size;

    public SlabImpl(int size) {
        this(size, false);
    }

    public SlabImpl(int size, boolean withPadding) {
        this(AddressableMemoryManager.allocate(size + (withPadding ? 4 : 0)), size);
    }

    public SlabImpl(long addr, int size) {
        this.address = addr;
        this.size = size;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public long getMemoryAddress() {
        return this.address;
    }

    @Override
    public void free() {
        AddressableMemoryManager.free(this.address);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{MemoryAddress=" + this.getMemoryAddress() + ", Size=" + this.getSize() + "}";
    }
}

