/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.offheap;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.DataSerializer;
import org.apache.geode.cache.Region;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.offheap.StoredObject;
import org.apache.geode.internal.serialization.DSCODE;

public abstract class AbstractStoredObject
implements StoredObject {
    @Override
    public Object getValueAsDeserializedHeapObject() {
        return this.getDeserializedValue(null, null);
    }

    @Override
    public byte[] getValueAsHeapByteArray() {
        if (this.isSerialized()) {
            return this.getSerializedValue();
        }
        return (byte[])this.getDeserializedForReading();
    }

    @Override
    public String getStringForm() {
        try {
            return StringUtils.forceToString(this.getDeserializedForReading());
        }
        catch (RuntimeException ex) {
            return "Could not convert object to string because " + ex;
        }
    }

    @Override
    public Object getDeserializedForReading() {
        return this.getDeserializedValue(null, null);
    }

    @Override
    public Object getDeserializedWritableCopy(Region r, RegionEntry re) {
        return this.getDeserializedValue(null, null);
    }

    @Override
    public Object getValue() {
        if (this.isSerialized()) {
            return this.getSerializedValue();
        }
        throw new IllegalStateException("Can not call getValue on StoredObject that is not serialized");
    }

    @Override
    public void writeValueAsByteArray(DataOutput out) throws IOException {
        DataSerializer.writeByteArray(this.getSerializedValue(), out);
    }

    @Override
    public void sendTo(DataOutput out) throws IOException {
        if (this.isSerialized()) {
            out.write(this.getSerializedValue());
        } else {
            Object objToSend = this.getDeserializedForReading();
            DataSerializer.writeObject(objToSend, out);
        }
    }

    @Override
    public void sendAsByteArray(DataOutput out) throws IOException {
        byte[] bytes = this.isSerialized() ? this.getSerializedValue() : (byte[])this.getDeserializedForReading();
        DataSerializer.writeByteArray(bytes, out);
    }

    @Override
    public void sendAsCachedDeserializable(DataOutput out) throws IOException {
        if (!this.isSerialized()) {
            throw new IllegalStateException("sendAsCachedDeserializable can only be called on serialized StoredObjects");
        }
        InternalDataSerializer.writeDSFIDHeader(-64, out);
        this.sendAsByteArray(out);
    }

    @Override
    public boolean usesHeapForStorage() {
        return false;
    }

    @Override
    public boolean isSerializedPdxInstance() {
        if (!this.isSerialized()) {
            return false;
        }
        byte dsCode = this.readDataByte(0);
        return dsCode == DSCODE.PDX.toByte() || dsCode == DSCODE.PDX_ENUM.toByte() || dsCode == DSCODE.PDX_INLINE_ENUM.toByte();
    }

    @Override
    public StoredObject getStoredObjectWithoutHeapForm() {
        return this;
    }
}

