/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.BreakIterator;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Handler;
import java.util.logging.Level;
import org.apache.geode.LogWriter;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.i18n.LogWriterI18n;
import org.apache.geode.i18n.StringId;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.logging.DateFormatter;
import org.apache.geode.internal.logging.GemFireHandler;
import org.apache.geode.internal.logging.InternalLogWriter;
import org.apache.geode.internal.process.StartupStatusListener;
import org.apache.geode.logging.internal.executors.LoggingThread;

@Deprecated
public abstract class LogWriterImpl
implements InternalLogWriter {
    private static final int LOGGING_FLAGS_MASK = 0xFFFFFF;
    private static final int SECURITY_LOGGING_FLAG = 0x40000000;
    @MakeNotStatic
    private static volatile StartupStatusListener startupListener;
    private final DateFormat timeFormatter = DateFormatter.createDateFormat();

    protected LogWriterImpl() {
    }

    @Override
    public abstract int getLogWriterLevel();

    @Override
    public boolean isSecure() {
        return false;
    }

    public static String allowedLogLevels() {
        StringBuilder sb = new StringBuilder(64);
        for (int i = 0; i < levelNames.size(); ++i) {
            if (i != 0) {
                sb.append('|');
            }
            sb.append((String)levelNames.get(i));
        }
        return sb.toString();
    }

    public static String levelToString(int level) {
        switch (level) {
            case -2147483648: {
                return "all";
            }
            case 300: {
                return "finest";
            }
            case 400: {
                return "finer";
            }
            case 500: {
                return "fine";
            }
            case 700: {
                return "config";
            }
            case 800: {
                return "info";
            }
            case 900: {
                return "warning";
            }
            case 950: {
                return "error";
            }
            case 1000: {
                return "severe";
            }
            case 0x7FFFFFFF: {
                return "none";
            }
        }
        return LogWriterImpl.levelToStringSpecialCase(level);
    }

    private static String levelToStringSpecialCase(int levelWithFlags) {
        if ((levelWithFlags & 0x40000000) != 0) {
            int level = levelWithFlags ^ 0x40000000;
            return "security-" + LogWriterImpl.levelToString(level);
        }
        return "level-" + levelWithFlags;
    }

    protected static int getRealLogLevel(int levelWithFlags) {
        if (levelWithFlags == Integer.MAX_VALUE) {
            return levelWithFlags;
        }
        return levelWithFlags & 0xFFFFFF;
    }

    public static String join(Object[] array) {
        return LogWriterImpl.join(array, " ");
    }

    public static String join(Object[] array, String joinString) {
        return LogWriterImpl.join(Arrays.asList(array), joinString);
    }

    public static String join(List<?> list) {
        return LogWriterImpl.join(list, " ");
    }

    public static String join(List<?> list, String joinString) {
        StringBuilder result = new StringBuilder(80);
        boolean firstTime = true;
        for (Object object : list) {
            if (firstTime) {
                firstTime = false;
            } else {
                result.append(joinString);
            }
            result.append(object);
        }
        return result.toString();
    }

    public static int levelNameToCode(String levelName) {
        if ("all".equalsIgnoreCase(levelName)) {
            return Integer.MIN_VALUE;
        }
        if ("finest".equalsIgnoreCase(levelName) || "trace".equalsIgnoreCase(levelName)) {
            return 300;
        }
        if ("finer".equalsIgnoreCase(levelName)) {
            return 400;
        }
        if ("fine".equalsIgnoreCase(levelName) || "debug".equalsIgnoreCase(levelName)) {
            return 500;
        }
        if ("config".equalsIgnoreCase(levelName)) {
            return 700;
        }
        if ("info".equalsIgnoreCase(levelName)) {
            return 800;
        }
        if ("warning".equalsIgnoreCase(levelName) || "warn".equalsIgnoreCase(levelName)) {
            return 900;
        }
        if ("error".equalsIgnoreCase(levelName)) {
            return 950;
        }
        if ("severe".equalsIgnoreCase(levelName) || "fatal".equalsIgnoreCase(levelName)) {
            return 1000;
        }
        if ("none".equalsIgnoreCase(levelName)) {
            return Integer.MAX_VALUE;
        }
        try {
            if (levelName.startsWith("level-")) {
                String levelValue = levelName.substring("level-".length());
                return Integer.parseInt(levelValue);
            }
        }
        catch (NullPointerException | NumberFormatException runtimeException) {
            // empty catch block
        }
        throw new IllegalArgumentException("Unknown log-level \"" + levelName + "\". Valid levels are: " + LogWriterImpl.join(levelNames) + ".");
    }

    protected String getTimeStamp() {
        return this.formatDate(new Date());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String formatDate(Date date) {
        try {
            DateFormat dateFormat = this.timeFormatter;
            synchronized (dateFormat) {
                return this.timeFormatter.format(date);
            }
        }
        catch (Exception e1) {
            try {
                return date.toString();
            }
            catch (Exception e2) {
                try {
                    return Long.toString(date.getTime());
                }
                catch (Exception e3) {
                    return "timestampFormatFailed";
                }
            }
        }
    }

    @Override
    public boolean severeEnabled() {
        return this.getLogWriterLevel() <= 1000;
    }

    @Override
    public void severe(String message, Throwable throwable) {
        if (this.severeEnabled()) {
            this.put(1000, message, throwable);
        }
    }

    @Override
    public void severe(String message) {
        this.severe(message, null);
    }

    @Override
    public void severe(Throwable throwable) {
        this.severe("", throwable);
    }

    @Override
    public void severe(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.severeEnabled()) {
            this.put(1000, messageId, parameters, throwable);
        }
    }

    @Override
    public void severe(StringId messageId, Object parameter, Throwable throwable) {
        if (this.severeEnabled()) {
            this.put(1000, messageId, new Object[]{parameter}, throwable);
        }
    }

    @Override
    public void severe(StringId messageId, Throwable throwable) {
        this.severe(messageId, null, throwable);
    }

    @Override
    public void severe(StringId messageId, Object[] parameters) {
        this.severe(messageId, parameters, (Throwable)null);
    }

    @Override
    public void severe(StringId messageId, Object parameter) {
        this.severe(messageId, parameter, null);
    }

    @Override
    public void severe(StringId messageId) {
        this.severe(messageId, null, null);
    }

    @Override
    public boolean errorEnabled() {
        return this.getLogWriterLevel() <= 950;
    }

    @Override
    public void error(String message, Throwable throwable) {
        if (this.errorEnabled()) {
            this.put(950, message, throwable);
        }
    }

    @Override
    public void error(String message) {
        this.error(message, null);
    }

    @Override
    public void error(Throwable throwable) {
        this.error("", throwable);
    }

    @Override
    public void error(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.errorEnabled()) {
            this.put(950, messageId, parameters, throwable);
        }
    }

    @Override
    public void error(StringId messageId, Object parameter, Throwable throwable) {
        if (this.errorEnabled()) {
            this.put(950, messageId, new Object[]{parameter}, throwable);
        }
    }

    @Override
    public void error(StringId messageId, Throwable throwable) {
        this.error(messageId, null, throwable);
    }

    @Override
    public void error(StringId messageId, Object[] parameters) {
        this.error(messageId, parameters, (Throwable)null);
    }

    @Override
    public void error(StringId messageId, Object parameter) {
        this.error(messageId, parameter, null);
    }

    @Override
    public void error(StringId messageId) {
        this.error(messageId, null, null);
    }

    @Override
    public boolean warningEnabled() {
        return this.getLogWriterLevel() <= 900;
    }

    @Override
    public void warning(String message, Throwable throwable) {
        if (this.warningEnabled()) {
            this.put(900, message, throwable);
        }
    }

    @Override
    public void warning(String message) {
        this.warning(message, null);
    }

    @Override
    public void warning(Throwable throwable) {
        this.warning("", throwable);
    }

    @Override
    public void warning(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.warningEnabled()) {
            this.put(900, messageId, parameters, throwable);
        }
    }

    @Override
    public void warning(StringId messageId, Object parameter, Throwable throwable) {
        if (this.warningEnabled()) {
            this.put(900, messageId, new Object[]{parameter}, throwable);
        }
    }

    @Override
    public void warning(StringId messageId, Throwable throwable) {
        this.warning(messageId, null, throwable);
    }

    @Override
    public void warning(StringId messageId, Object[] parameters) {
        this.warning(messageId, parameters, (Throwable)null);
    }

    @Override
    public void warning(StringId messageId, Object parameter) {
        this.warning(messageId, parameter, null);
    }

    @Override
    public void warning(StringId messageId) {
        this.warning(messageId, null, null);
    }

    @Override
    public boolean infoEnabled() {
        return this.getLogWriterLevel() <= 800;
    }

    @Override
    public void info(String message, Throwable throwable) {
        if (this.infoEnabled()) {
            this.put(800, message, throwable);
        }
    }

    @Override
    public void info(String message) {
        this.info(message, null);
    }

    @Override
    public void info(Throwable throwable) {
        this.info("", throwable);
    }

    @Override
    public void info(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.infoEnabled()) {
            this.put(800, messageId, parameters, throwable);
        }
    }

    @Override
    public void info(StringId messageId, Object parameter, Throwable throwable) {
        if (this.infoEnabled()) {
            this.put(800, messageId, new Object[]{parameter}, throwable);
        }
    }

    @Override
    public void info(StringId messageId, Throwable throwable) {
        this.info(messageId, null, throwable);
    }

    @Override
    public void info(StringId messageId, Object[] parameters) {
        this.info(messageId, parameters, (Throwable)null);
    }

    @Override
    public void info(StringId messageId, Object parameter) {
        this.info(messageId, parameter, null);
    }

    @Override
    public void info(StringId messageId) {
        this.info(messageId, null, null);
    }

    @Override
    public boolean configEnabled() {
        return this.getLogWriterLevel() <= 700;
    }

    @Override
    public void config(String message, Throwable throwable) {
        if (this.configEnabled()) {
            this.put(700, message, throwable);
        }
    }

    @Override
    public void config(String message) {
        this.config(message, null);
    }

    @Override
    public void config(Throwable throwable) {
        this.config("", throwable);
    }

    @Override
    public void config(StringId messageId, Object[] parameters, Throwable throwable) {
        if (this.configEnabled()) {
            this.put(700, messageId, parameters, throwable);
        }
    }

    @Override
    public void config(StringId messageId, Object parameter, Throwable throwable) {
        if (this.configEnabled()) {
            this.put(700, messageId, new Object[]{parameter}, throwable);
        }
    }

    @Override
    public void config(StringId messageId, Throwable throwable) {
        this.config(messageId, null, throwable);
    }

    @Override
    public void config(StringId messageId, Object[] parameters) {
        this.config(messageId, parameters, (Throwable)null);
    }

    @Override
    public void config(StringId messageId, Object parameter) {
        this.config(messageId, parameter, null);
    }

    @Override
    public void config(StringId messageId) {
        this.config(messageId, null, null);
    }

    @Override
    public boolean fineEnabled() {
        return this.getLogWriterLevel() <= 500;
    }

    @Override
    public void fine(String message, Throwable throwable) {
        if (this.fineEnabled()) {
            this.put(500, message, throwable);
        }
    }

    @Override
    public void fine(String message) {
        this.fine(message, null);
    }

    @Override
    public void fine(Throwable throwable) {
        this.fine(null, throwable);
    }

    @Override
    public boolean finerEnabled() {
        return this.getLogWriterLevel() <= 400;
    }

    @Override
    public void finer(String message, Throwable throwable) {
        if (this.finerEnabled()) {
            this.put(400, message, throwable);
        }
    }

    @Override
    public void finer(String message) {
        this.finer(message, null);
    }

    @Override
    public void finer(Throwable throwable) {
        this.finer(null, throwable);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod) {
        if (this.finerEnabled()) {
            this.finer("ENTRY " + sourceClass + ":" + sourceMethod);
        }
    }

    @Override
    public void exiting(String sourceClass, String sourceMethod) {
        if (this.finerEnabled()) {
            this.finer("RETURN " + sourceClass + ":" + sourceMethod);
        }
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (this.finerEnabled()) {
            this.finer("THROW " + sourceClass + ":" + sourceMethod, thrown);
        }
    }

    @Override
    public boolean finestEnabled() {
        return this.getLogWriterLevel() <= 300;
    }

    @Override
    public void finest(String message, Throwable throwable) {
        if (this.finestEnabled()) {
            this.put(300, message, throwable);
        }
    }

    @Override
    public void finest(String message) {
        this.finest(message, null);
    }

    @Override
    public void finest(Throwable throwable) {
        this.finest(null, throwable);
    }

    public void startup(StringId msgID, Object[] params) {
        String message = msgID.toLocalizedString(params);
        StartupStatusListener listener = startupListener;
        if (listener != null) {
            listener.setStatus(message);
        }
        if (this.infoEnabled()) {
            this.put(800, message, null);
        }
    }

    @Override
    public abstract void put(int var1, String var2, Throwable var3);

    @Override
    public abstract void put(int var1, StringId var2, Object[] var3, Throwable var4);

    static void formatText(PrintWriter writer, String target, int initialLength) {
        BreakIterator boundary = BreakIterator.getLineInstance();
        boundary.setText(target);
        int start = boundary.first();
        int end = boundary.next();
        int lineLength = initialLength;
        while (end != -1) {
            char endChar = target.charAt(end - 1);
            while (!Character.isWhitespace(endChar)) {
                int lastEnd = end;
                end = boundary.next();
                if (end == -1) {
                    end = lastEnd;
                    break;
                }
                endChar = target.charAt(end - 1);
            }
            int wordEnd = end;
            if (endChar == '\n') {
                if (--wordEnd > 0 && target.charAt(wordEnd - 1) == '\r') {
                    --wordEnd;
                }
            } else if (endChar == '\t') {
                lineLength += 7;
            }
            String word = target.substring(start, wordEnd);
            lineLength += word.length();
            writer.print(word);
            if (endChar == '\n' || endChar == '\r') {
                writer.println();
                writer.print("  ");
                lineLength = 2;
            }
            start = end;
            end = boundary.next();
        }
        if (lineLength != 0) {
            writer.println();
        }
    }

    private boolean isLoggable(int level) {
        return this.getLogWriterLevel() <= level;
    }

    public void log(int level, String message, Throwable thrown) {
        if (this.isLoggable(level)) {
            this.put(level, message, thrown);
        }
    }

    public void log(int level, String message) {
        if (this.isLoggable(level)) {
            this.put(level, message, null);
        }
    }

    @Override
    public Handler getHandler() {
        return new GemFireHandler(this);
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public void logTraces(boolean toStdout, Thread targetThread, int interval, AtomicBoolean done) {
        if (targetThread == null) {
            return;
        }
        LoggingThread watcherThread = new LoggingThread("Stack Tracer for '" + targetThread.getName() + "'", false, () -> {
            while (!done.get()) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (done.get() || !targetThread.isAlive()) continue;
                StringBuilder sb = new StringBuilder(500);
                if (toStdout) {
                    sb.append("[trace ").append(this.getTimeStamp()).append("] ");
                }
                StackTraceElement[] els = targetThread.getStackTrace();
                sb.append("Stack trace for '").append(targetThread).append("'").append(System.lineSeparator());
                if (els.length > 0) {
                    for (StackTraceElement el : els) {
                        sb.append("\tat ").append(el).append(System.lineSeparator());
                    }
                } else {
                    sb.append("    no stack").append(System.lineSeparator());
                }
                if (toStdout) {
                    System.out.println(sb);
                    continue;
                }
                this.info(sb.toString());
            }
        });
        watcherThread.start();
    }

    public static StringBuilder getStackTrace(Thread targetThread) {
        StringBuilder sb = new StringBuilder(500);
        StackTraceElement[] els = targetThread.getStackTrace();
        sb.append("Stack trace for '").append(targetThread).append("'").append(System.lineSeparator());
        if (els.length > 0) {
            for (StackTraceElement el : els) {
                sb.append("\tat ").append(el).append(System.lineSeparator());
            }
        } else {
            sb.append("    no stack").append(System.lineSeparator());
        }
        return sb;
    }

    @Override
    public LogWriter convertToLogWriter() {
        return this;
    }

    @Override
    public LogWriterI18n convertToLogWriterI18n() {
        return this;
    }

    public static void setStartupListener(StartupStatusListener mainListener) {
        startupListener = mainListener;
    }

    public static StartupStatusListener getStartupListener() {
        return startupListener;
    }

    static {
        Assert.assertTrue(Integer.MIN_VALUE == Level.ALL.intValue());
        Assert.assertTrue(Integer.MAX_VALUE == Level.OFF.intValue());
        Assert.assertTrue(300 == Level.FINEST.intValue());
        Assert.assertTrue(400 == Level.FINER.intValue());
        Assert.assertTrue(500 == Level.FINE.intValue());
        Assert.assertTrue(700 == Level.CONFIG.intValue());
        Assert.assertTrue(800 == Level.INFO.intValue());
        Assert.assertTrue(900 == Level.WARNING.intValue());
        Assert.assertTrue(1000 == Level.SEVERE.intValue());
        int logLevels = 1020;
        Assert.assertTrue(logLevels == (logLevels & 0xFFFFFF));
        Assert.assertTrue(0 == (logLevels & 0x40000000));
    }
}

