/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.util.Set;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TransactionDataNodeHasDepartedException;
import org.apache.geode.cache.TransactionDataNotColocatedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.TXStateStub;
import org.apache.geode.internal.cache.tx.RemoteFetchKeysMessage;
import org.apache.geode.internal.cache.tx.RemoteSizeMessage;
import org.apache.geode.internal.cache.tx.TXRegionStub;

public abstract class AbstractPeerTXRegionStub
implements TXRegionStub {
    protected final TXStateStub state;

    public AbstractPeerTXRegionStub(TXStateStub txstate) {
        this.state = txstate;
    }

    protected abstract InternalRegion getRegion();

    @Override
    public Set getRegionKeysForIteration() {
        try {
            RemoteFetchKeysMessage.FetchKeysResponse response = RemoteFetchKeysMessage.send((LocalRegion)this.getRegion(), this.state.getTarget());
            return response.waitForKeys();
        }
        catch (RegionDestroyedException regionDestroyedException) {
            throw new TransactionDataNotColocatedException(String.format("Region %s not colocated with other regions in transaction", regionDestroyedException.getRegionFullPath()), regionDestroyedException);
        }
        catch (CacheClosedException cacheClosedException) {
            throw new TransactionDataNodeHasDepartedException("Cache was closed while fetching keys");
        }
        catch (TransactionException transactionException) {
            throw transactionException;
        }
        catch (Exception exception) {
            throw new TransactionException(exception);
        }
    }

    @Override
    public int entryCount() {
        try {
            RemoteSizeMessage.SizeResponse response = RemoteSizeMessage.send(this.state.getTarget(), this.getRegion());
            return response.waitForSize();
        }
        catch (RegionDestroyedException regionDestroyedException) {
            throw new TransactionDataNotColocatedException(String.format("Region %s not colocated with other regions in transaction", regionDestroyedException.getRegionFullPath()), regionDestroyedException);
        }
        catch (CacheClosedException cacheClosedException) {
            throw new TransactionDataNodeHasDepartedException("Cache was closed while performing size operation");
        }
        catch (TransactionException transactionException) {
            throw transactionException;
        }
        catch (Exception exception) {
            throw new TransactionException(exception);
        }
    }
}

