/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.geode.cache.CacheRuntimeException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.SerialDistributionMessage;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.PRLocallyDestroyedException;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class FlushMessage
extends SerialDistributionMessage
implements MessageWithReply {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;
    int prId;
    int bucketId;
    int processorId;

    public FlushMessage() {
    }

    private FlushMessage(int prId, int bucketId, int processorId, InternalDistributedMember recipient) {
        this.prId = prId;
        this.bucketId = bucketId;
        this.processorId = processorId;
        this.setRecipient(recipient);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void process(ClusterDistributionManager dm) {
        if (this.bucketId != Integer.MIN_VALUE) {
            if (logger.isDebugEnabled()) {
                logger.debug("Received sent FlushMessage {}", (Object)this);
            }
            try {
                PartitionedRegion p = PartitionedRegion.getPRFromId(this.prId);
                Assert.assertTrue(p.getRegionAdvisor().isPrimaryForBucket(this.bucketId));
                return;
            }
            catch (PRLocallyDestroyedException fre) {
                if (!logger.isDebugEnabled()) return;
                logger.debug("Sending reply despite Region getting locally destroyed prId={}", (Object)this.prId, (Object)fre);
                return;
            }
            catch (CacheRuntimeException ce) {
                logger.debug("Sending reply despite unavailable Partitioned Region using prId={}", (Object)this.prId, (Object)ce);
                return;
            }
            finally {
                dm.putOutgoing(new FlushMessage(this.prId, Integer.MIN_VALUE, this.getProcessorId(), this.getSender()));
            }
        } else {
            ReplyProcessor21 rep;
            if (logger.isDebugEnabled()) {
                logger.debug("Processing FlushMessage as a response {}", (Object)this);
            }
            if ((rep = ReplyProcessor21.getProcessor(this.processorId)) == null) return;
            rep.process(this);
        }
    }

    public static ReplyProcessor21 send(InternalDistributedMember primary, PartitionedRegion p, int bucketId) {
        ReplyProcessor21 reply = new ReplyProcessor21(p.getDistributionManager(), primary);
        FlushMessage fm = new FlushMessage(p.getPRId(), bucketId, reply.getProcessorId(), primary);
        p.getDistributionManager().putOutgoing(fm);
        return reply;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    public int getDSFID() {
        return 49;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.prId = in.readInt();
        this.bucketId = in.readInt();
        this.processorId = in.readInt();
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeInt(this.prId);
        out.writeInt(this.bucketId);
        out.writeInt(this.processorId);
    }
}

