/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.execute.metrics;

import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsFactory;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.execute.metrics.FunctionServiceStats;
import org.apache.geode.internal.cache.execute.metrics.FunctionStats;
import org.apache.geode.internal.cache.execute.metrics.FunctionStatsImpl;
import org.apache.geode.internal.lang.utils.JavaWorkarounds;
import org.apache.geode.internal.statistics.DummyStatisticsImpl;
import org.apache.geode.metrics.internal.NoopMeterRegistry;

public class FunctionStatsManager {
    private final boolean statsDisabled;
    private final StatisticsFactory statisticsFactory;
    private final FunctionServiceStats functionServiceStats;
    private final Supplier<MeterRegistry> meterRegistrySupplier;
    private final Map<String, FunctionStats> functionExecutionStatsMap;
    private final Statistics dummyStatistics;
    private final MeterRegistry noopMeterRegistry;
    private final FunctionStats dummyFunctionStats;

    public FunctionStatsManager(boolean statsDisabled, StatisticsFactory statisticsFactory, Supplier<MeterRegistry> meterRegistrySupplier) {
        this(statsDisabled, statisticsFactory, new FunctionServiceStats(statisticsFactory, "FunctionExecution"), meterRegistrySupplier);
    }

    @VisibleForTesting
    FunctionStatsManager(boolean statsDisabled, StatisticsFactory statisticsFactory, FunctionServiceStats functionServiceStats, Supplier<MeterRegistry> meterRegistrySupplier) {
        this.statsDisabled = statsDisabled;
        this.statisticsFactory = statisticsFactory;
        this.functionServiceStats = functionServiceStats;
        this.meterRegistrySupplier = meterRegistrySupplier;
        this.functionExecutionStatsMap = new ConcurrentHashMap<String, FunctionStats>();
        this.dummyStatistics = FunctionStatsManager.createDummyStatistics();
        this.noopMeterRegistry = FunctionStatsManager.createNoopMeterRegistry();
        this.dummyFunctionStats = FunctionStatsManager.createDummyFunctionStats(this.noopMeterRegistry, this.dummyStatistics);
    }

    public FunctionServiceStats getFunctionServiceStats() {
        return this.functionServiceStats;
    }

    public FunctionStats getFunctionStatsByName(String name) {
        MeterRegistry meterRegistryFromSupplier = this.meterRegistrySupplier.get();
        if (this.statsDisabled && meterRegistryFromSupplier == null) {
            return this.dummyFunctionStats;
        }
        return (FunctionStats)JavaWorkarounds.computeIfAbsent(this.functionExecutionStatsMap, (Object)name, key -> this.create((String)key, meterRegistryFromSupplier));
    }

    public void close() {
        for (FunctionStats functionstats : this.functionExecutionStatsMap.values()) {
            functionstats.close();
        }
        this.functionServiceStats.close();
    }

    private FunctionStats create(String name, MeterRegistry meterRegistryFromSupplier) {
        MeterRegistry meterRegistry = meterRegistryFromSupplier == null ? this.noopMeterRegistry : meterRegistryFromSupplier;
        Statistics statistics = this.statsDisabled ? this.dummyStatistics : this.statisticsFactory.createAtomicStatistics(FunctionStatsImpl.getStatisticsType(), name);
        return new FunctionStatsImpl(name, meterRegistry, statistics, this.functionServiceStats);
    }

    public static FunctionStats getFunctionStats(String functionID, InternalDistributedSystem ds) {
        return ds.getFunctionStatsManager().getFunctionStatsByName(functionID);
    }

    public static FunctionStats getFunctionStats(String functionID) {
        InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
        if (ds == null) {
            return FunctionStatsManager.createDummyFunctionStats();
        }
        return ds.getFunctionStatsManager().getFunctionStatsByName(functionID);
    }

    @VisibleForTesting
    FunctionStats getDummyFunctionStats() {
        return this.dummyFunctionStats;
    }

    @VisibleForTesting
    Statistics getDummyStatistics() {
        return this.dummyStatistics;
    }

    @VisibleForTesting
    MeterRegistry getNoopMeterRegistry() {
        return this.noopMeterRegistry;
    }

    private static FunctionStats createDummyFunctionStats() {
        return FunctionStatsManager.createDummyFunctionStats(FunctionStatsManager.createNoopMeterRegistry(), FunctionStatsManager.createDummyStatistics());
    }

    private static FunctionStats createDummyFunctionStats(MeterRegistry meterRegistry, Statistics statistics) {
        return new FunctionStatsImpl("", meterRegistry, statistics, FunctionServiceStats.createDummy());
    }

    private static DummyStatisticsImpl createDummyStatistics() {
        return new DummyStatisticsImpl(FunctionStatsImpl.getStatisticsType(), null, 0L);
    }

    private static NoopMeterRegistry createNoopMeterRegistry() {
        return new NoopMeterRegistry();
    }

    public static interface Factory {
        public FunctionStatsManager create(boolean var1, StatisticsFactory var2, Supplier<MeterRegistry> var3);
    }
}

