/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.backup;

import org.apache.geode.distributed.DistributedLockService;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.Assert;

public class BackupLockService {
    public static final String LOCK_SERVICE_NAME = BackupLockService.class.getSimpleName();
    private static final String LOCK_NAME = LOCK_SERVICE_NAME + "_token";
    private static final Object LOCK_SYNC = new Object();

    BackupLockService() {
    }

    boolean obtainLock(DistributionManager dm) {
        return this.getLockService(dm).lock(LOCK_NAME, 0L, -1L);
    }

    void releaseLock(DistributionManager dm) {
        this.getLockService(dm).unlock(LOCK_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DistributedLockService getLockService(DistributionManager dm) {
        DistributedLockService dls = DistributedLockService.getServiceNamed(LOCK_SERVICE_NAME);
        if (dls == null) {
            Object object = LOCK_SYNC;
            synchronized (object) {
                dls = DistributedLockService.getServiceNamed(LOCK_SERVICE_NAME);
                if (dls == null) {
                    dls = DistributedLockService.create(LOCK_SERVICE_NAME, dm.getSystem());
                }
            }
        }
        Assert.assertTrue(dls != null);
        return dls;
    }
}

