/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.TransactionEvent;
import org.apache.geode.cache.TransactionId;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.BucketRegion;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.TXId;

public class TXRmtEvent
implements TransactionEvent {
    private final TransactionId txId;
    private final Cache cache;
    private List events;

    TXRmtEvent(TransactionId txId, Cache cache) {
        this.txId = txId;
        this.cache = cache;
        this.events = null;
    }

    @Override
    public TransactionId getTransactionId() {
        return this.txId;
    }

    private boolean isEventUserVisible(CacheEvent ce) {
        return BucketRegion.FORCE_LOCAL_LISTENERS_INVOCATION || !(ce.getRegion() instanceof PartitionedRegion);
    }

    public List getEvents() {
        if (this.events == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<CacheEvent> result = new ArrayList<CacheEvent>(this.events.size());
        for (Object event : this.events) {
            CacheEvent ce = (CacheEvent)event;
            if (!this.isEventUserVisible(ce)) continue;
            result.add(ce);
        }
        if (result.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(result);
    }

    public boolean hasOnlyInternalEvents() {
        if (this.events == null || this.events.isEmpty()) {
            return false;
        }
        for (CacheEvent event : this.events) {
            LocalRegion region;
            if (!this.isEventUserVisible(event) || (region = (LocalRegion)event.getRegion()) == null || region.isPdxTypesRegion() || region.isInternalRegion()) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.events == null || this.events.isEmpty();
    }

    private EntryEventImpl createEvent(InternalRegion r, Operation op, RegionEntry re, Object key, Object newValue, Object aCallbackArgument) {
        InternalDistributedMember originator = ((TXId)this.txId).getMemberId();
        InternalRegion eventRegion = r;
        if (r.isUsedForPartitionedRegionBucket()) {
            eventRegion = r.getPartitionedRegion();
        }
        EntryEventImpl event = EntryEventImpl.create(eventRegion, op, key, newValue, aCallbackArgument, true, originator);
        event.setOldValue(re.getValueInVM(r));
        event.setTransactionId(this.getTransactionId());
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addEvent(EntryEventImpl e) {
        TXRmtEvent tXRmtEvent = this;
        synchronized (tXRmtEvent) {
            if (this.events == null) {
                this.events = new ArrayList();
            }
            this.events.add(e);
        }
    }

    public void addDestroy(InternalRegion r, RegionEntry re, Object key, Object aCallbackArgument) {
        this.addEvent(this.createEvent(r, Operation.DESTROY, re, key, null, aCallbackArgument));
    }

    public void addInvalidate(InternalRegion r, RegionEntry re, Object key, Object newValue, Object aCallbackArgument) {
        this.addEvent(this.createEvent(r, Operation.INVALIDATE, re, key, newValue, aCallbackArgument));
    }

    public void addPut(Operation putOp, InternalRegion r, RegionEntry re, Object key, Object newValue, Object aCallbackArgument) {
        this.addEvent(this.createEvent(r, putOp, re, key, newValue, aCallbackArgument));
    }

    @Override
    public Cache getCache() {
        return this.cache;
    }

    public void freeOffHeapResources() {
        if (this.events != null) {
            for (EntryEventImpl e : this.events) {
                e.release();
            }
        }
    }
}

