/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.DistributionAdvisor;
import org.apache.geode.distributed.internal.ProfileListener;
import org.apache.geode.internal.cache.CacheDistributionAdvisor;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class SenderIdMonitor
implements ProfileListener,
DistributionAdvisor.InitializationListener {
    private static final Logger logger = LogService.getLogger();
    private final InternalRegion region;
    private final CacheDistributionAdvisor advisor;
    private volatile Set<String> illegalGatewaySenderIds = null;
    private volatile Set<String> illegalAsyncEventQueueIds = null;
    private boolean gatewaySenderIdsDifferWarningMessage;
    private boolean asyncQueueIdsDifferWarningMessage;

    private SenderIdMonitor(InternalRegion region, CacheDistributionAdvisor advisor) {
        this.region = region;
        this.advisor = advisor;
    }

    public static SenderIdMonitor createSenderIdMonitor(InternalRegion region, CacheDistributionAdvisor advisor) {
        SenderIdMonitor senderIdMonitor = new SenderIdMonitor(region, advisor);
        advisor.addProfileChangeListener(senderIdMonitor);
        advisor.setInitializationListener(senderIdMonitor);
        return senderIdMonitor;
    }

    @Override
    public void profileCreated(DistributionAdvisor.Profile profile) {
        this.update();
    }

    @Override
    public void profileUpdated(DistributionAdvisor.Profile profile) {
        this.update();
    }

    @Override
    public void profileRemoved(DistributionAdvisor.Profile profile, boolean destroyed) {
        this.update();
    }

    @Override
    public void initialized() {
        this.update();
    }

    public void update() {
        if (!this.advisor.pollIsInitialized()) {
            return;
        }
        Set<String> gatewaySenderIds = this.region.getGatewaySenderIds();
        Set<String> visibleAsyncEventQueueIds = this.region.getVisibleAsyncEventQueueIds();
        AtomicBoolean foundIllegalState = new AtomicBoolean();
        this.advisor.accept((advisor, profile, idx, count, aggregate) -> {
            if (profile instanceof CacheDistributionAdvisor.CacheProfile) {
                CacheDistributionAdvisor.CacheProfile cp = (CacheDistributionAdvisor.CacheProfile)profile;
                if (!gatewaySenderIds.equals(cp.gatewaySenderIds)) {
                    foundIllegalState.set(true);
                    this.illegalGatewaySenderIds = cp.gatewaySenderIds;
                }
                if (!visibleAsyncEventQueueIds.equals(cp.asyncEventQueueIds)) {
                    foundIllegalState.set(true);
                    this.illegalAsyncEventQueueIds = cp.asyncEventQueueIds;
                }
            }
            return true;
        }, null);
        if (!foundIllegalState.get()) {
            this.illegalGatewaySenderIds = null;
            this.illegalAsyncEventQueueIds = null;
        }
    }

    @VisibleForTesting
    public boolean getGatewaySenderIdsDifferWarningMessage() {
        return this.gatewaySenderIdsDifferWarningMessage;
    }

    @VisibleForTesting
    public boolean getAsyncQueueIdsDifferWarningMessage() {
        return this.asyncQueueIdsDifferWarningMessage;
    }

    public void checkSenderIds() {
        if (this.illegalGatewaySenderIds != null) {
            if (!this.gatewaySenderIdsDifferWarningMessage) {
                this.gatewaySenderIdsDifferWarningMessage = true;
                logger.warn("Region {} has {} gateway sender IDs. Another member has the same region with {} gateway sender IDs. For the same region, across all members, gateway sender ids should be same.", (Object)this.region.getName(), this.region.getGatewaySenderIds(), this.illegalGatewaySenderIds);
            }
        } else if (this.gatewaySenderIdsDifferWarningMessage) {
            this.gatewaySenderIdsDifferWarningMessage = false;
            logger.warn("Region {} now has the same gateway sender IDs on all members. The previous problem with them being different has been corrected.", (Object)this.region.getName());
        }
        if (this.illegalAsyncEventQueueIds != null) {
            if (!this.asyncQueueIdsDifferWarningMessage) {
                this.asyncQueueIdsDifferWarningMessage = true;
                logger.warn("Region {} has {} AsyncEvent queue IDs. Another member has the same region with {} AsyncEvent queue IDs. For the same region, across all members, AsyncEvent queue IDs should be same.", (Object)this.region.getName(), this.region.getVisibleAsyncEventQueueIds(), this.illegalAsyncEventQueueIds);
            }
        } else if (this.asyncQueueIdsDifferWarningMessage) {
            this.asyncQueueIdsDifferWarningMessage = false;
            logger.warn("Region {} now has the same AsyncEvent queue IDs on all members. The previous problem with them being different has been corrected.", (Object)this.region.getName());
        }
    }
}

