/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Set;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class LatestLastAccessTimeReplyProcessor
extends ReplyProcessor21 {
    private static final Logger logger = LogService.getLogger();
    private long latestLastAccessTime = 0L;

    public LatestLastAccessTimeReplyProcessor(DistributionManager dm, Set<InternalDistributedMember> recipients) {
        super(dm, recipients);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(DistributionMessage msg) {
        try {
            ReplyMessage reply = (ReplyMessage)msg;
            long replyTime = (Long)reply.getReturnValue();
            this.updateLatestLastAccessTime(replyTime);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "LatestLastAccessTimeReplyMessage return value is {}", (Object)replyTime);
            }
        }
        finally {
            super.process(msg);
        }
    }

    private synchronized void updateLatestLastAccessTime(long newTime) {
        if (newTime > this.latestLastAccessTime) {
            this.latestLastAccessTime = newTime;
        }
    }

    public synchronized long getLatestLastAccessTime() {
        return this.latestLastAccessTime;
    }
}

